@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chatbot.kotlin.inputs

import com.pulumi.aws.chatbot.inputs.GetSlackWorkspacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSlackWorkspace.
 * @property slackTeamName Slack workspace name configured with AWS Chatbot.
 */
public data class GetSlackWorkspacePlainArgs(
    public val slackTeamName: String,
) : ConvertibleToJava<com.pulumi.aws.chatbot.inputs.GetSlackWorkspacePlainArgs> {
    override fun toJava(): com.pulumi.aws.chatbot.inputs.GetSlackWorkspacePlainArgs =
        com.pulumi.aws.chatbot.inputs.GetSlackWorkspacePlainArgs.builder()
            .slackTeamName(slackTeamName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSlackWorkspacePlainArgs].
 */
@PulumiTagMarker
public class GetSlackWorkspacePlainArgsBuilder internal constructor() {
    private var slackTeamName: String? = null

    /**
     * @param value Slack workspace name configured with AWS Chatbot.
     */
    @JvmName("bfhwmolxnuxalmnn")
    public suspend fun slackTeamName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.slackTeamName = mapped
    }

    internal fun build(): GetSlackWorkspacePlainArgs = GetSlackWorkspacePlainArgs(
        slackTeamName = slackTeamName ?: throw PulumiNullFieldException("slackTeamName"),
    )
}
