@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chatbot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getSlackWorkspace.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property slackTeamId ID of the Slack Workspace assigned by AWS Chatbot.
 * @property slackTeamName
 */
public data class GetSlackWorkspaceResult(
    public val id: String,
    public val slackTeamId: String,
    public val slackTeamName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.chatbot.outputs.GetSlackWorkspaceResult): GetSlackWorkspaceResult = GetSlackWorkspaceResult(
            id = javaType.id(),
            slackTeamId = javaType.slackTeamId(),
            slackTeamName = javaType.slackTeamName(),
        )
    }
}
