@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.kotlin.outputs.SdkvoiceSipMediaApplicationEndpoints
import com.pulumi.aws.chime.kotlin.outputs.SdkvoiceSipMediaApplicationEndpoints.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SdkvoiceSipMediaApplication].
 */
@PulumiTagMarker
public class SdkvoiceSipMediaApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SdkvoiceSipMediaApplicationArgs = SdkvoiceSipMediaApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SdkvoiceSipMediaApplicationArgsBuilder.() -> Unit) {
        val builder = SdkvoiceSipMediaApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SdkvoiceSipMediaApplication {
        val builtJavaResource =
            com.pulumi.aws.chime.SdkvoiceSipMediaApplication(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SdkvoiceSipMediaApplication(builtJavaResource)
    }
}

/**
 * A ChimeSDKVoice SIP Media Application is a managed object that passes values from a SIP rule to a target AWS Lambda function.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.chime.SdkvoiceSipMediaApplication("example", {
 *     awsRegion: "us-east-1",
 *     name: "example-sip-media-application",
 *     endpoints: {
 *         lambdaArn: test.arn,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.chime.SdkvoiceSipMediaApplication("example",
 *     aws_region="us-east-1",
 *     name="example-sip-media-application",
 *     endpoints={
 *         "lambda_arn": test["arn"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Chime.SdkvoiceSipMediaApplication("example", new()
 *     {
 *         AwsRegion = "us-east-1",
 *         Name = "example-sip-media-application",
 *         Endpoints = new Aws.Chime.Inputs.SdkvoiceSipMediaApplicationEndpointsArgs
 *         {
 *             LambdaArn = test.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chime"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chime.NewSdkvoiceSipMediaApplication(ctx, "example", &chime.SdkvoiceSipMediaApplicationArgs{
 * 			AwsRegion: pulumi.String("us-east-1"),
 * 			Name:      pulumi.String("example-sip-media-application"),
 * 			Endpoints: &chime.SdkvoiceSipMediaApplicationEndpointsArgs{
 * 				LambdaArn: pulumi.Any(test.Arn),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.SdkvoiceSipMediaApplication;
 * import com.pulumi.aws.chime.SdkvoiceSipMediaApplicationArgs;
 * import com.pulumi.aws.chime.inputs.SdkvoiceSipMediaApplicationEndpointsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SdkvoiceSipMediaApplication("example", SdkvoiceSipMediaApplicationArgs.builder()
 *             .awsRegion("us-east-1")
 *             .name("example-sip-media-application")
 *             .endpoints(SdkvoiceSipMediaApplicationEndpointsArgs.builder()
 *                 .lambdaArn(test.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:chime:SdkvoiceSipMediaApplication
 *     properties:
 *       awsRegion: us-east-1
 *       name: example-sip-media-application
 *       endpoints:
 *         lambdaArn: ${test.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a ChimeSDKVoice SIP Media Application using the `id`. For example:
 * ```sh
 * $ pulumi import aws:chime/sdkvoiceSipMediaApplication:SdkvoiceSipMediaApplication example abcdef123456
 * ```
 */
public class SdkvoiceSipMediaApplication internal constructor(
    override val javaResource: com.pulumi.aws.chime.SdkvoiceSipMediaApplication,
) : KotlinCustomResource(javaResource, SdkvoiceSipMediaApplicationMapper) {
    /**
     * ARN (Amazon Resource Name) of the AWS Chime SDK Voice Sip Media Application
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The AWS Region in which the AWS Chime SDK Voice Sip Media Application is created.
     */
    public val awsRegion: Output<String>
        get() = javaResource.awsRegion().applyValue({ args0 -> args0 })

    /**
     * List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one endpoint is supported. See `endpoints`.
     */
    public val endpoints: Output<SdkvoiceSipMediaApplicationEndpoints>
        get() = javaResource.endpoints().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The name of the AWS Chime SDK Voice Sip Media Application.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object SdkvoiceSipMediaApplicationMapper : ResourceMapper<SdkvoiceSipMediaApplication> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.chime.SdkvoiceSipMediaApplication::class == javaResource::class

    override fun map(javaResource: Resource): SdkvoiceSipMediaApplication =
        SdkvoiceSipMediaApplication(javaResource as com.pulumi.aws.chime.SdkvoiceSipMediaApplication)
}

/**
 * @see [SdkvoiceSipMediaApplication].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SdkvoiceSipMediaApplication].
 */
public suspend fun sdkvoiceSipMediaApplication(
    name: String,
    block: suspend SdkvoiceSipMediaApplicationResourceBuilder.() -> Unit,
): SdkvoiceSipMediaApplication {
    val builder = SdkvoiceSipMediaApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SdkvoiceSipMediaApplication].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sdkvoiceSipMediaApplication(name: String): SdkvoiceSipMediaApplication {
    val builder = SdkvoiceSipMediaApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
