@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.SdkvoiceSipMediaApplicationArgs.builder
import com.pulumi.aws.chime.kotlin.inputs.SdkvoiceSipMediaApplicationEndpointsArgs
import com.pulumi.aws.chime.kotlin.inputs.SdkvoiceSipMediaApplicationEndpointsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A ChimeSDKVoice SIP Media Application is a managed object that passes values from a SIP rule to a target AWS Lambda function.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.chime.SdkvoiceSipMediaApplication("example", {
 *     awsRegion: "us-east-1",
 *     name: "example-sip-media-application",
 *     endpoints: {
 *         lambdaArn: test.arn,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.chime.SdkvoiceSipMediaApplication("example",
 *     aws_region="us-east-1",
 *     name="example-sip-media-application",
 *     endpoints={
 *         "lambda_arn": test["arn"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Chime.SdkvoiceSipMediaApplication("example", new()
 *     {
 *         AwsRegion = "us-east-1",
 *         Name = "example-sip-media-application",
 *         Endpoints = new Aws.Chime.Inputs.SdkvoiceSipMediaApplicationEndpointsArgs
 *         {
 *             LambdaArn = test.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chime"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chime.NewSdkvoiceSipMediaApplication(ctx, "example", &chime.SdkvoiceSipMediaApplicationArgs{
 * 			AwsRegion: pulumi.String("us-east-1"),
 * 			Name:      pulumi.String("example-sip-media-application"),
 * 			Endpoints: &chime.SdkvoiceSipMediaApplicationEndpointsArgs{
 * 				LambdaArn: pulumi.Any(test.Arn),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.SdkvoiceSipMediaApplication;
 * import com.pulumi.aws.chime.SdkvoiceSipMediaApplicationArgs;
 * import com.pulumi.aws.chime.inputs.SdkvoiceSipMediaApplicationEndpointsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SdkvoiceSipMediaApplication("example", SdkvoiceSipMediaApplicationArgs.builder()
 *             .awsRegion("us-east-1")
 *             .name("example-sip-media-application")
 *             .endpoints(SdkvoiceSipMediaApplicationEndpointsArgs.builder()
 *                 .lambdaArn(test.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:chime:SdkvoiceSipMediaApplication
 *     properties:
 *       awsRegion: us-east-1
 *       name: example-sip-media-application
 *       endpoints:
 *         lambdaArn: ${test.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a ChimeSDKVoice SIP Media Application using the `id`. For example:
 * ```sh
 * $ pulumi import aws:chime/sdkvoiceSipMediaApplication:SdkvoiceSipMediaApplication example abcdef123456
 * ```
 * @property awsRegion The AWS Region in which the AWS Chime SDK Voice Sip Media Application is created.
 * @property endpoints List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one endpoint is supported. See `endpoints`.
 * @property name The name of the AWS Chime SDK Voice Sip Media Application.
 * The following arguments are optional:
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SdkvoiceSipMediaApplicationArgs(
    public val awsRegion: Output<String>? = null,
    public val endpoints: Output<SdkvoiceSipMediaApplicationEndpointsArgs>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.SdkvoiceSipMediaApplicationArgs> {
    override fun toJava(): com.pulumi.aws.chime.SdkvoiceSipMediaApplicationArgs =
        com.pulumi.aws.chime.SdkvoiceSipMediaApplicationArgs.builder()
            .awsRegion(awsRegion?.applyValue({ args0 -> args0 }))
            .endpoints(endpoints?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SdkvoiceSipMediaApplicationArgs].
 */
@PulumiTagMarker
public class SdkvoiceSipMediaApplicationArgsBuilder internal constructor() {
    private var awsRegion: Output<String>? = null

    private var endpoints: Output<SdkvoiceSipMediaApplicationEndpointsArgs>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The AWS Region in which the AWS Chime SDK Voice Sip Media Application is created.
     */
    @JvmName("cjsglhxodpkdcqtq")
    public suspend fun awsRegion(`value`: Output<String>) {
        this.awsRegion = value
    }

    /**
     * @param value List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one endpoint is supported. See `endpoints`.
     */
    @JvmName("jkcjumqrgsoprikr")
    public suspend fun endpoints(`value`: Output<SdkvoiceSipMediaApplicationEndpointsArgs>) {
        this.endpoints = value
    }

    /**
     * @param value The name of the AWS Chime SDK Voice Sip Media Application.
     * The following arguments are optional:
     */
    @JvmName("mgwuvpegsgslcpqm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("huloxecicmgqtqnh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The AWS Region in which the AWS Chime SDK Voice Sip Media Application is created.
     */
    @JvmName("ynhuuvumdkcnpbjn")
    public suspend fun awsRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsRegion = mapped
    }

    /**
     * @param value List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one endpoint is supported. See `endpoints`.
     */
    @JvmName("qdhhbukvomrpqcdb")
    public suspend fun endpoints(`value`: SdkvoiceSipMediaApplicationEndpointsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one endpoint is supported. See `endpoints`.
     */
    @JvmName("tuanhvjfxhgggpdu")
    public suspend fun endpoints(argument: suspend SdkvoiceSipMediaApplicationEndpointsArgsBuilder.() -> Unit) {
        val toBeMapped = SdkvoiceSipMediaApplicationEndpointsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param value The name of the AWS Chime SDK Voice Sip Media Application.
     * The following arguments are optional:
     */
    @JvmName("neqxjvdromqjorfx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fnyfbbpqygtvdpof")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ekptahfwyxxtpghu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SdkvoiceSipMediaApplicationArgs = SdkvoiceSipMediaApplicationArgs(
        awsRegion = awsRegion,
        endpoints = endpoints,
        name = name,
        tags = tags,
    )
}
