@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.kotlin.outputs.SdkvoiceSipRuleTargetApplication
import com.pulumi.aws.chime.kotlin.outputs.SdkvoiceSipRuleTargetApplication.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SdkvoiceSipRule].
 */
@PulumiTagMarker
public class SdkvoiceSipRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SdkvoiceSipRuleArgs = SdkvoiceSipRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SdkvoiceSipRuleArgsBuilder.() -> Unit) {
        val builder = SdkvoiceSipRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SdkvoiceSipRule {
        val builtJavaResource = com.pulumi.aws.chime.SdkvoiceSipRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SdkvoiceSipRule(builtJavaResource)
    }
}

/**
 * A SIP rule associates your SIP media application with a phone number or a Request URI hostname. You can associate a SIP rule with more than one SIP media application. Each application then runs only that rule.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.chime.SdkvoiceSipRule("example", {
 *     name: "example-sip-rule",
 *     triggerType: "RequestUriHostname",
 *     triggerValue: example_voice_connector.outboundHostName,
 *     targetApplications: [{
 *         priority: 1,
 *         sipMediaApplicationId: example_sma.id,
 *         awsRegion: "us-east-1",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.chime.SdkvoiceSipRule("example",
 *     name="example-sip-rule",
 *     trigger_type="RequestUriHostname",
 *     trigger_value=example_voice_connector["outboundHostName"],
 *     target_applications=[{
 *         "priority": 1,
 *         "sip_media_application_id": example_sma["id"],
 *         "aws_region": "us-east-1",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Chime.SdkvoiceSipRule("example", new()
 *     {
 *         Name = "example-sip-rule",
 *         TriggerType = "RequestUriHostname",
 *         TriggerValue = example_voice_connector.OutboundHostName,
 *         TargetApplications = new[]
 *         {
 *             new Aws.Chime.Inputs.SdkvoiceSipRuleTargetApplicationArgs
 *             {
 *                 Priority = 1,
 *                 SipMediaApplicationId = example_sma.Id,
 *                 AwsRegion = "us-east-1",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chime"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chime.NewSdkvoiceSipRule(ctx, "example", &chime.SdkvoiceSipRuleArgs{
 * 			Name:         pulumi.String("example-sip-rule"),
 * 			TriggerType:  pulumi.String("RequestUriHostname"),
 * 			TriggerValue: pulumi.Any(example_voice_connector.OutboundHostName),
 * 			TargetApplications: chime.SdkvoiceSipRuleTargetApplicationArray{
 * 				&chime.SdkvoiceSipRuleTargetApplicationArgs{
 * 					Priority:              pulumi.Int(1),
 * 					SipMediaApplicationId: pulumi.Any(example_sma.Id),
 * 					AwsRegion:             pulumi.String("us-east-1"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.SdkvoiceSipRule;
 * import com.pulumi.aws.chime.SdkvoiceSipRuleArgs;
 * import com.pulumi.aws.chime.inputs.SdkvoiceSipRuleTargetApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SdkvoiceSipRule("example", SdkvoiceSipRuleArgs.builder()
 *             .name("example-sip-rule")
 *             .triggerType("RequestUriHostname")
 *             .triggerValue(example_voice_connector.outboundHostName())
 *             .targetApplications(SdkvoiceSipRuleTargetApplicationArgs.builder()
 *                 .priority(1)
 *                 .sipMediaApplicationId(example_sma.id())
 *                 .awsRegion("us-east-1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:chime:SdkvoiceSipRule
 *     properties:
 *       name: example-sip-rule
 *       triggerType: RequestUriHostname
 *       triggerValue: ${["example-voice-connector"].outboundHostName}
 *       targetApplications:
 *         - priority: 1
 *           sipMediaApplicationId: ${["example-sma"].id}
 *           awsRegion: us-east-1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a ChimeSDKVoice SIP Rule using the `id`. For example:
 * ```sh
 * $ pulumi import aws:chime/sdkvoiceSipRule:SdkvoiceSipRule example abcdef123456
 * ```
 */
public class SdkvoiceSipRule internal constructor(
    override val javaResource: com.pulumi.aws.chime.SdkvoiceSipRule,
) : KotlinCustomResource(javaResource, SdkvoiceSipRuleMapper) {
    /**
     * Enables or disables a rule. You must disable rules before you can delete them.
     */
    public val disabled: Output<Boolean>?
        get() = javaResource.disabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the SIP rule.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used. See `target_applications`.
     */
    public val targetApplications: Output<List<SdkvoiceSipRuleTargetApplication>>
        get() = javaResource.targetApplications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The type of trigger assigned to the SIP rule in `trigger_value`. Valid values are `RequestUriHostname` or `ToPhoneNumber`.
     */
    public val triggerType: Output<String>
        get() = javaResource.triggerType().applyValue({ args0 -> args0 })

    /**
     * If `trigger_type` is `RequestUriHostname`, the value can be the outbound host name of an Amazon Chime Voice Connector. If `trigger_type` is `ToPhoneNumber`, the value can be a customer-owned phone number in the E164 format. The Sip Media Application specified in the Sip Rule is triggered if the request URI in an incoming SIP request matches the `RequestUriHostname`, or if the "To" header in the incoming SIP request matches the `ToPhoneNumber` value.
     * The following arguments are optional:
     */
    public val triggerValue: Output<String>
        get() = javaResource.triggerValue().applyValue({ args0 -> args0 })
}

public object SdkvoiceSipRuleMapper : ResourceMapper<SdkvoiceSipRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.chime.SdkvoiceSipRule::class == javaResource::class

    override fun map(javaResource: Resource): SdkvoiceSipRule = SdkvoiceSipRule(
        javaResource as
            com.pulumi.aws.chime.SdkvoiceSipRule,
    )
}

/**
 * @see [SdkvoiceSipRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SdkvoiceSipRule].
 */
public suspend fun sdkvoiceSipRule(
    name: String,
    block: suspend SdkvoiceSipRuleResourceBuilder.() -> Unit,
): SdkvoiceSipRule {
    val builder = SdkvoiceSipRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SdkvoiceSipRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sdkvoiceSipRule(name: String): SdkvoiceSipRule {
    val builder = SdkvoiceSipRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
