@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.kotlin.outputs.SdkvoiceVoiceProfileDomainServerSideEncryptionConfiguration
import com.pulumi.aws.chime.kotlin.outputs.SdkvoiceVoiceProfileDomainServerSideEncryptionConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SdkvoiceVoiceProfileDomain].
 */
@PulumiTagMarker
public class SdkvoiceVoiceProfileDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SdkvoiceVoiceProfileDomainArgs = SdkvoiceVoiceProfileDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SdkvoiceVoiceProfileDomainArgsBuilder.() -> Unit) {
        val builder = SdkvoiceVoiceProfileDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SdkvoiceVoiceProfileDomain {
        val builtJavaResource = com.pulumi.aws.chime.SdkvoiceVoiceProfileDomain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SdkvoiceVoiceProfileDomain(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Chime SDK Voice Profile Domain.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {
 *     description: "KMS Key for Voice Profile Domain",
 *     deletionWindowInDays: 7,
 * });
 * const exampleSdkvoiceVoiceProfileDomain = new aws.chime.SdkvoiceVoiceProfileDomain("example", {
 *     name: "ExampleVoiceProfileDomain",
 *     serverSideEncryptionConfiguration: {
 *         kmsKeyArn: example.arn,
 *     },
 *     description: "My Voice Profile Domain",
 *     tags: {
 *         key1: "value1",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example",
 *     description="KMS Key for Voice Profile Domain",
 *     deletion_window_in_days=7)
 * example_sdkvoice_voice_profile_domain = aws.chime.SdkvoiceVoiceProfileDomain("example",
 *     name="ExampleVoiceProfileDomain",
 *     server_side_encryption_configuration={
 *         "kms_key_arn": example.arn,
 *     },
 *     description="My Voice Profile Domain",
 *     tags={
 *         "key1": "value1",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "KMS Key for Voice Profile Domain",
 *         DeletionWindowInDays = 7,
 *     });
 *     var exampleSdkvoiceVoiceProfileDomain = new Aws.Chime.SdkvoiceVoiceProfileDomain("example", new()
 *     {
 *         Name = "ExampleVoiceProfileDomain",
 *         ServerSideEncryptionConfiguration = new Aws.Chime.Inputs.SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs
 *         {
 *             KmsKeyArn = example.Arn,
 *         },
 *         Description = "My Voice Profile Domain",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chime"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("KMS Key for Voice Profile Domain"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = chime.NewSdkvoiceVoiceProfileDomain(ctx, "example", &chime.SdkvoiceVoiceProfileDomainArgs{
 * 			Name: pulumi.String("ExampleVoiceProfileDomain"),
 * 			ServerSideEncryptionConfiguration: &chime.SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs{
 * 				KmsKeyArn: example.Arn,
 * 			},
 * 			Description: pulumi.String("My Voice Profile Domain"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.chime.SdkvoiceVoiceProfileDomain;
 * import com.pulumi.aws.chime.SdkvoiceVoiceProfileDomainArgs;
 * import com.pulumi.aws.chime.inputs.SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("KMS Key for Voice Profile Domain")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleSdkvoiceVoiceProfileDomain = new SdkvoiceVoiceProfileDomain("exampleSdkvoiceVoiceProfileDomain", SdkvoiceVoiceProfileDomainArgs.builder()
 *             .name("ExampleVoiceProfileDomain")
 *             .serverSideEncryptionConfiguration(SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs.builder()
 *                 .kmsKeyArn(example.arn())
 *                 .build())
 *             .description("My Voice Profile Domain")
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: KMS Key for Voice Profile Domain
 *       deletionWindowInDays: 7
 *   exampleSdkvoiceVoiceProfileDomain:
 *     type: aws:chime:SdkvoiceVoiceProfileDomain
 *     name: example
 *     properties:
 *       name: ExampleVoiceProfileDomain
 *       serverSideEncryptionConfiguration:
 *         kmsKeyArn: ${example.arn}
 *       description: My Voice Profile Domain
 *       tags:
 *         key1: value1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS Chime SDK Voice Profile Domain using the `id`. For example:
 * ```sh
 * $ pulumi import aws:chime/sdkvoiceVoiceProfileDomain:SdkvoiceVoiceProfileDomain example abcdef123456
 * ```
 */
public class SdkvoiceVoiceProfileDomain internal constructor(
    override val javaResource: com.pulumi.aws.chime.SdkvoiceVoiceProfileDomain,
) : KotlinCustomResource(javaResource, SdkvoiceVoiceProfileDomainMapper) {
    /**
     * ARN of the Voice Profile Domain.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of Voice Profile Domain.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of Voice Profile Domain.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration for server side encryption.
     */
    public val serverSideEncryptionConfiguration:
        Output<SdkvoiceVoiceProfileDomainServerSideEncryptionConfiguration>
        get() = javaResource.serverSideEncryptionConfiguration().applyValue({ args0 ->
            args0.let({ args0 -> toKotlin(args0) })
        })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object SdkvoiceVoiceProfileDomainMapper : ResourceMapper<SdkvoiceVoiceProfileDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.chime.SdkvoiceVoiceProfileDomain::class == javaResource::class

    override fun map(javaResource: Resource): SdkvoiceVoiceProfileDomain =
        SdkvoiceVoiceProfileDomain(javaResource as com.pulumi.aws.chime.SdkvoiceVoiceProfileDomain)
}

/**
 * @see [SdkvoiceVoiceProfileDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SdkvoiceVoiceProfileDomain].
 */
public suspend fun sdkvoiceVoiceProfileDomain(
    name: String,
    block: suspend SdkvoiceVoiceProfileDomainResourceBuilder.() -> Unit,
): SdkvoiceVoiceProfileDomain {
    val builder = SdkvoiceVoiceProfileDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SdkvoiceVoiceProfileDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sdkvoiceVoiceProfileDomain(name: String): SdkvoiceVoiceProfileDomain {
    val builder = SdkvoiceVoiceProfileDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
