@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.SdkvoiceVoiceProfileDomainArgs.builder
import com.pulumi.aws.chime.kotlin.inputs.SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs
import com.pulumi.aws.chime.kotlin.inputs.SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Chime SDK Voice Profile Domain.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {
 *     description: "KMS Key for Voice Profile Domain",
 *     deletionWindowInDays: 7,
 * });
 * const exampleSdkvoiceVoiceProfileDomain = new aws.chime.SdkvoiceVoiceProfileDomain("example", {
 *     name: "ExampleVoiceProfileDomain",
 *     serverSideEncryptionConfiguration: {
 *         kmsKeyArn: example.arn,
 *     },
 *     description: "My Voice Profile Domain",
 *     tags: {
 *         key1: "value1",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example",
 *     description="KMS Key for Voice Profile Domain",
 *     deletion_window_in_days=7)
 * example_sdkvoice_voice_profile_domain = aws.chime.SdkvoiceVoiceProfileDomain("example",
 *     name="ExampleVoiceProfileDomain",
 *     server_side_encryption_configuration={
 *         "kms_key_arn": example.arn,
 *     },
 *     description="My Voice Profile Domain",
 *     tags={
 *         "key1": "value1",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "KMS Key for Voice Profile Domain",
 *         DeletionWindowInDays = 7,
 *     });
 *     var exampleSdkvoiceVoiceProfileDomain = new Aws.Chime.SdkvoiceVoiceProfileDomain("example", new()
 *     {
 *         Name = "ExampleVoiceProfileDomain",
 *         ServerSideEncryptionConfiguration = new Aws.Chime.Inputs.SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs
 *         {
 *             KmsKeyArn = example.Arn,
 *         },
 *         Description = "My Voice Profile Domain",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chime"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("KMS Key for Voice Profile Domain"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = chime.NewSdkvoiceVoiceProfileDomain(ctx, "example", &chime.SdkvoiceVoiceProfileDomainArgs{
 * 			Name: pulumi.String("ExampleVoiceProfileDomain"),
 * 			ServerSideEncryptionConfiguration: &chime.SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs{
 * 				KmsKeyArn: example.Arn,
 * 			},
 * 			Description: pulumi.String("My Voice Profile Domain"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.chime.SdkvoiceVoiceProfileDomain;
 * import com.pulumi.aws.chime.SdkvoiceVoiceProfileDomainArgs;
 * import com.pulumi.aws.chime.inputs.SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("KMS Key for Voice Profile Domain")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleSdkvoiceVoiceProfileDomain = new SdkvoiceVoiceProfileDomain("exampleSdkvoiceVoiceProfileDomain", SdkvoiceVoiceProfileDomainArgs.builder()
 *             .name("ExampleVoiceProfileDomain")
 *             .serverSideEncryptionConfiguration(SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs.builder()
 *                 .kmsKeyArn(example.arn())
 *                 .build())
 *             .description("My Voice Profile Domain")
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: KMS Key for Voice Profile Domain
 *       deletionWindowInDays: 7
 *   exampleSdkvoiceVoiceProfileDomain:
 *     type: aws:chime:SdkvoiceVoiceProfileDomain
 *     name: example
 *     properties:
 *       name: ExampleVoiceProfileDomain
 *       serverSideEncryptionConfiguration:
 *         kmsKeyArn: ${example.arn}
 *       description: My Voice Profile Domain
 *       tags:
 *         key1: value1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS Chime SDK Voice Profile Domain using the `id`. For example:
 * ```sh
 * $ pulumi import aws:chime/sdkvoiceVoiceProfileDomain:SdkvoiceVoiceProfileDomain example abcdef123456
 * ```
 * @property description Description of Voice Profile Domain.
 * @property name Name of Voice Profile Domain.
 * @property serverSideEncryptionConfiguration Configuration for server side encryption.
 * @property tags
 */
public data class SdkvoiceVoiceProfileDomainArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val serverSideEncryptionConfiguration: Output<SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.SdkvoiceVoiceProfileDomainArgs> {
    override fun toJava(): com.pulumi.aws.chime.SdkvoiceVoiceProfileDomainArgs =
        com.pulumi.aws.chime.SdkvoiceVoiceProfileDomainArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .serverSideEncryptionConfiguration(
                serverSideEncryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SdkvoiceVoiceProfileDomainArgs].
 */
@PulumiTagMarker
public class SdkvoiceVoiceProfileDomainArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var serverSideEncryptionConfiguration:
        Output<SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description of Voice Profile Domain.
     */
    @JvmName("tiiovwcigydxwcfe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of Voice Profile Domain.
     */
    @JvmName("walanrtcyvgqsxug")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration for server side encryption.
     */
    @JvmName("cpekxahsskafcgns")
    public suspend fun serverSideEncryptionConfiguration(`value`: Output<SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs>) {
        this.serverSideEncryptionConfiguration = value
    }

    /**
     * @param value
     */
    @JvmName("mpxvcuosbuqddvny")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description of Voice Profile Domain.
     */
    @JvmName("juqvailxshckxeae")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of Voice Profile Domain.
     */
    @JvmName("nalsjasjgtgpkfao")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration for server side encryption.
     */
    @JvmName("aowqulexhmlbtpqh")
    public suspend fun serverSideEncryptionConfiguration(`value`: SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideEncryptionConfiguration = mapped
    }

    /**
     * @param argument Configuration for server side encryption.
     */
    @JvmName("lixbbidoofxibmgo")
    public suspend fun serverSideEncryptionConfiguration(argument: suspend SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.serverSideEncryptionConfiguration = mapped
    }

    /**
     * @param value
     */
    @JvmName("jdqioklwwsjppsjh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("fxepynciycaotlxh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SdkvoiceVoiceProfileDomainArgs = SdkvoiceVoiceProfileDomainArgs(
        description = description,
        name = name,
        serverSideEncryptionConfiguration = serverSideEncryptionConfiguration,
        tags = tags,
    )
}
