@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.VoiceConnectorLoggingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.chime.VoiceConnector("default", {
 *     name: "vc-name-test",
 *     requireEncryption: true,
 * });
 * const defaultVoiceConnectorLogging = new aws.chime.VoiceConnectorLogging("default", {
 *     enableSipLogs: true,
 *     enableMediaMetricLogs: true,
 *     voiceConnectorId: _default.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.chime.VoiceConnector("default",
 *     name="vc-name-test",
 *     require_encryption=True)
 * default_voice_connector_logging = aws.chime.VoiceConnectorLogging("default",
 *     enable_sip_logs=True,
 *     enable_media_metric_logs=True,
 *     voice_connector_id=default.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Chime.VoiceConnector("default", new()
 *     {
 *         Name = "vc-name-test",
 *         RequireEncryption = true,
 *     });
 *     var defaultVoiceConnectorLogging = new Aws.Chime.VoiceConnectorLogging("default", new()
 *     {
 *         EnableSipLogs = true,
 *         EnableMediaMetricLogs = true,
 *         VoiceConnectorId = @default.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chime"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chime.NewVoiceConnector(ctx, "default", &chime.VoiceConnectorArgs{
 * 			Name:              pulumi.String("vc-name-test"),
 * 			RequireEncryption: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = chime.NewVoiceConnectorLogging(ctx, "default", &chime.VoiceConnectorLoggingArgs{
 * 			EnableSipLogs:         pulumi.Bool(true),
 * 			EnableMediaMetricLogs: pulumi.Bool(true),
 * 			VoiceConnectorId:      _default.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorLogging;
 * import com.pulumi.aws.chime.VoiceConnectorLoggingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new VoiceConnector("default", VoiceConnectorArgs.builder()
 *             .name("vc-name-test")
 *             .requireEncryption(true)
 *             .build());
 *         var defaultVoiceConnectorLogging = new VoiceConnectorLogging("defaultVoiceConnectorLogging", VoiceConnectorLoggingArgs.builder()
 *             .enableSipLogs(true)
 *             .enableMediaMetricLogs(true)
 *             .voiceConnectorId(default_.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:chime:VoiceConnector
 *     properties:
 *       name: vc-name-test
 *       requireEncryption: true
 *   defaultVoiceConnectorLogging:
 *     type: aws:chime:VoiceConnectorLogging
 *     name: default
 *     properties:
 *       enableSipLogs: true
 *       enableMediaMetricLogs: true
 *       voiceConnectorId: ${default.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Chime Voice Connector Logging using the `voice_connector_id`. For example:
 * ```sh
 * $ pulumi import aws:chime/voiceConnectorLogging:VoiceConnectorLogging default abcdef1ghij2klmno3pqr4
 * ```
 * @property enableMediaMetricLogs When true, enables logging of detailed media metrics for Voice Connectors to Amazon CloudWatch logs.
 * @property enableSipLogs When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
 * @property voiceConnectorId The Amazon Chime Voice Connector ID.
 */
public data class VoiceConnectorLoggingArgs(
    public val enableMediaMetricLogs: Output<Boolean>? = null,
    public val enableSipLogs: Output<Boolean>? = null,
    public val voiceConnectorId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.VoiceConnectorLoggingArgs> {
    override fun toJava(): com.pulumi.aws.chime.VoiceConnectorLoggingArgs =
        com.pulumi.aws.chime.VoiceConnectorLoggingArgs.builder()
            .enableMediaMetricLogs(enableMediaMetricLogs?.applyValue({ args0 -> args0 }))
            .enableSipLogs(enableSipLogs?.applyValue({ args0 -> args0 }))
            .voiceConnectorId(voiceConnectorId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VoiceConnectorLoggingArgs].
 */
@PulumiTagMarker
public class VoiceConnectorLoggingArgsBuilder internal constructor() {
    private var enableMediaMetricLogs: Output<Boolean>? = null

    private var enableSipLogs: Output<Boolean>? = null

    private var voiceConnectorId: Output<String>? = null

    /**
     * @param value When true, enables logging of detailed media metrics for Voice Connectors to Amazon CloudWatch logs.
     */
    @JvmName("gxdgeyswmvaepylh")
    public suspend fun enableMediaMetricLogs(`value`: Output<Boolean>) {
        this.enableMediaMetricLogs = value
    }

    /**
     * @param value When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
     */
    @JvmName("gtipnwncdoaepmot")
    public suspend fun enableSipLogs(`value`: Output<Boolean>) {
        this.enableSipLogs = value
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("scsptadhrgmqoosn")
    public suspend fun voiceConnectorId(`value`: Output<String>) {
        this.voiceConnectorId = value
    }

    /**
     * @param value When true, enables logging of detailed media metrics for Voice Connectors to Amazon CloudWatch logs.
     */
    @JvmName("hneuvuckpnonbebs")
    public suspend fun enableMediaMetricLogs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableMediaMetricLogs = mapped
    }

    /**
     * @param value When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
     */
    @JvmName("luhhcffmmwwgcxbb")
    public suspend fun enableSipLogs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSipLogs = mapped
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("nfsvsjgriqgujpxx")
    public suspend fun voiceConnectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceConnectorId = mapped
    }

    internal fun build(): VoiceConnectorLoggingArgs = VoiceConnectorLoggingArgs(
        enableMediaMetricLogs = enableMediaMetricLogs,
        enableSipLogs = enableSipLogs,
        voiceConnectorId = voiceConnectorId,
    )
}
