@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.VoiceConnectorStreamingArgs.builder
import com.pulumi.aws.chime.kotlin.inputs.VoiceConnectorStreamingMediaInsightsConfigurationArgs
import com.pulumi.aws.chime.kotlin.inputs.VoiceConnectorStreamingMediaInsightsConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Adds a streaming configuration for the specified Amazon Chime Voice Connector. The streaming configuration specifies whether media streaming is enabled for sending to Amazon Kinesis.
 * It also sets the retention period, in hours, for the Amazon Kinesis data.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.chime.VoiceConnector("default", {
 *     name: "vc-name-test",
 *     requireEncryption: true,
 * });
 * const defaultVoiceConnectorStreaming = new aws.chime.VoiceConnectorStreaming("default", {
 *     disabled: false,
 *     voiceConnectorId: _default.id,
 *     dataRetention: 7,
 *     streamingNotificationTargets: ["SQS"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.chime.VoiceConnector("default",
 *     name="vc-name-test",
 *     require_encryption=True)
 * default_voice_connector_streaming = aws.chime.VoiceConnectorStreaming("default",
 *     disabled=False,
 *     voice_connector_id=default.id,
 *     data_retention=7,
 *     streaming_notification_targets=["SQS"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Chime.VoiceConnector("default", new()
 *     {
 *         Name = "vc-name-test",
 *         RequireEncryption = true,
 *     });
 *     var defaultVoiceConnectorStreaming = new Aws.Chime.VoiceConnectorStreaming("default", new()
 *     {
 *         Disabled = false,
 *         VoiceConnectorId = @default.Id,
 *         DataRetention = 7,
 *         StreamingNotificationTargets = new[]
 *         {
 *             "SQS",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chime"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chime.NewVoiceConnector(ctx, "default", &chime.VoiceConnectorArgs{
 * 			Name:              pulumi.String("vc-name-test"),
 * 			RequireEncryption: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = chime.NewVoiceConnectorStreaming(ctx, "default", &chime.VoiceConnectorStreamingArgs{
 * 			Disabled:         pulumi.Bool(false),
 * 			VoiceConnectorId: _default.ID(),
 * 			DataRetention:    pulumi.Int(7),
 * 			StreamingNotificationTargets: pulumi.StringArray{
 * 				pulumi.String("SQS"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorStreaming;
 * import com.pulumi.aws.chime.VoiceConnectorStreamingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new VoiceConnector("default", VoiceConnectorArgs.builder()
 *             .name("vc-name-test")
 *             .requireEncryption(true)
 *             .build());
 *         var defaultVoiceConnectorStreaming = new VoiceConnectorStreaming("defaultVoiceConnectorStreaming", VoiceConnectorStreamingArgs.builder()
 *             .disabled(false)
 *             .voiceConnectorId(default_.id())
 *             .dataRetention(7)
 *             .streamingNotificationTargets("SQS")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:chime:VoiceConnector
 *     properties:
 *       name: vc-name-test
 *       requireEncryption: true
 *   defaultVoiceConnectorStreaming:
 *     type: aws:chime:VoiceConnectorStreaming
 *     name: default
 *     properties:
 *       disabled: false
 *       voiceConnectorId: ${default.id}
 *       dataRetention: 7
 *       streamingNotificationTargets:
 *         - SQS
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example Usage With Media Insights
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.chime.VoiceConnector("default", {
 *     name: "vc-name-test",
 *     requireEncryption: true,
 * });
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["mediapipelines&#46;chime&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "ExampleResourceAccessRole",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const exampleStream = new aws.kinesis.Stream("example", {
 *     name: "ExampleStream",
 *     shardCount: 2,
 * });
 * const example = new aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration("example", {
 *     name: "ExampleConfig",
 *     resourceAccessRoleArn: exampleRole.arn,
 *     elements: [
 *         {
 *             type: "AmazonTranscribeCallAnalyticsProcessor",
 *             amazonTranscribeCallAnalyticsProcessorConfiguration: {
 *                 languageCode: "en-US",
 *             },
 *         },
 *         {
 *             type: "KinesisDataStreamSink",
 *             kinesisDataStreamSinkConfiguration: {
 *                 insightsTarget: exampleStream.arn,
 *             },
 *         },
 *     ],
 * });
 * const defaultVoiceConnectorStreaming = new aws.chime.VoiceConnectorStreaming("default", {
 *     disabled: false,
 *     voiceConnectorId: _default.id,
 *     dataRetention: 7,
 *     streamingNotificationTargets: ["SQS"],
 *     mediaInsightsConfiguration: {
 *         disabled: false,
 *         configurationArn: example.arn,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.chime.VoiceConnector("default",
 *     name="vc-name-test",
 *     require_encryption=True)
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["mediapipelines&#46;chime&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * example_role = aws.iam.Role("example",
 *     name="ExampleResourceAccessRole",
 *     assume_role_policy=assume_role.json)
 * example_stream = aws.kinesis.Stream("example",
 *     name="ExampleStream",
 *     shard_count=2)
 * example = aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration("example",
 *     name="ExampleConfig",
 *     resource_access_role_arn=example_role.arn,
 *     elements=[
 *         {
 *             "type": "AmazonTranscribeCallAnalyticsProcessor",
 *             "amazon_transcribe_call_analytics_processor_configuration": {
 *                 "language_code": "en-US",
 *             },
 *         },
 *         {
 *             "type": "KinesisDataStreamSink",
 *             "kinesis_data_stream_sink_configuration": {
 *                 "insights_target": example_stream.arn,
 *             },
 *         },
 *     ])
 * default_voice_connector_streaming = aws.chime.VoiceConnectorStreaming("default",
 *     disabled=False,
 *     voice_connector_id=default.id,
 *     data_retention=7,
 *     streaming_notification_targets=["SQS"],
 *     media_insights_configuration={
 *         "disabled": False,
 *         "configuration_arn": example.arn,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Chime.VoiceConnector("default", new()
 *     {
 *         Name = "vc-name-test",
 *         RequireEncryption = true,
 *     });
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "mediapipelines.chime.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "ExampleResourceAccessRole",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleStream = new Aws.Kinesis.Stream("example", new()
 *     {
 *         Name = "ExampleStream",
 *         ShardCount = 2,
 *     });
 *     var example = new Aws.ChimeSDKMediaPipelines.MediaInsightsPipelineConfiguration("example", new()
 *     {
 *         Name = "ExampleConfig",
 *         ResourceAccessRoleArn = exampleRole.Arn,
 *         Elements = new[]
 *         {
 *             new Aws.ChimeSDKMediaPipelines.Inputs.MediaInsightsPipelineConfigurationElementArgs
 *             {
 *                 Type = "AmazonTranscribeCallAnalyticsProcessor",
 *                 AmazonTranscribeCallAnalyticsProcessorConfiguration = new Aws.ChimeSDKMediaPipelines.Inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs
 *                 {
 *                     LanguageCode = "en-US",
 *                 },
 *             },
 *             new Aws.ChimeSDKMediaPipelines.Inputs.MediaInsightsPipelineConfigurationElementArgs
 *             {
 *                 Type = "KinesisDataStreamSink",
 *                 KinesisDataStreamSinkConfiguration = new Aws.ChimeSDKMediaPipelines.Inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs
 *                 {
 *                     InsightsTarget = exampleStream.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var defaultVoiceConnectorStreaming = new Aws.Chime.VoiceConnectorStreaming("default", new()
 *     {
 *         Disabled = false,
 *         VoiceConnectorId = @default.Id,
 *         DataRetention = 7,
 *         StreamingNotificationTargets = new[]
 *         {
 *             "SQS",
 *         },
 *         MediaInsightsConfiguration = new Aws.Chime.Inputs.VoiceConnectorStreamingMediaInsightsConfigurationArgs
 *         {
 *             Disabled = false,
 *             ConfigurationArn = example.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chime"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chimesdkmediapipelines"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chime.NewVoiceConnector(ctx, "default", &chime.VoiceConnectorArgs{
 * 			Name:              pulumi.String("vc-name-test"),
 * 			RequireEncryption: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"mediapipelines.chime.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("ExampleResourceAccessRole"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStream, err := kinesis.NewStream(ctx, "example", &kinesis.StreamArgs{
 * 			Name:       pulumi.String("ExampleStream"),
 * 			ShardCount: pulumi.Int(2),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := chimesdkmediapipelines.NewMediaInsightsPipelineConfiguration(ctx, "example", &chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs{
 * 			Name:                  pulumi.String("ExampleConfig"),
 * 			ResourceAccessRoleArn: exampleRole.Arn,
 * 			Elements: chimesdkmediapipelines.MediaInsightsPipelineConfigurationElementArray{
 * 				&chimesdkmediapipelines.MediaInsightsPipelineConfigurationElementArgs{
 * 					Type: pulumi.String("AmazonTranscribeCallAnalyticsProcessor"),
 * 					AmazonTranscribeCallAnalyticsProcessorConfiguration: &chimesdkmediapipelines.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs{
 * 						LanguageCode: pulumi.String("en-US"),
 * 					},
 * 				},
 * 				&chimesdkmediapipelines.MediaInsightsPipelineConfigurationElementArgs{
 * 					Type: pulumi.String("KinesisDataStreamSink"),
 * 					KinesisDataStreamSinkConfiguration: &chimesdkmediapipelines.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs{
 * 						InsightsTarget: exampleStream.Arn,
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = chime.NewVoiceConnectorStreaming(ctx, "default", &chime.VoiceConnectorStreamingArgs{
 * 			Disabled:         pulumi.Bool(false),
 * 			VoiceConnectorId: _default.ID(),
 * 			DataRetention:    pulumi.Int(7),
 * 			StreamingNotificationTargets: pulumi.StringArray{
 * 				pulumi.String("SQS"),
 * 			},
 * 			MediaInsightsConfiguration: &chime.VoiceConnectorStreamingMediaInsightsConfigurationArgs{
 * 				Disabled:         pulumi.Bool(false),
 * 				ConfigurationArn: example.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import com.pulumi.aws.chime.VoiceConnectorStreaming;
 * import com.pulumi.aws.chime.VoiceConnectorStreamingArgs;
 * import com.pulumi.aws.chime.inputs.VoiceConnectorStreamingMediaInsightsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new VoiceConnector("default", VoiceConnectorArgs.builder()
 *             .name("vc-name-test")
 *             .requireEncryption(true)
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("mediapipelines.chime.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("ExampleResourceAccessRole")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleStream = new Stream("exampleStream", StreamArgs.builder()
 *             .name("ExampleStream")
 *             .shardCount(2)
 *             .build());
 *         var example = new MediaInsightsPipelineConfiguration("example", MediaInsightsPipelineConfigurationArgs.builder()
 *             .name("ExampleConfig")
 *             .resourceAccessRoleArn(exampleRole.arn())
 *             .elements(
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("AmazonTranscribeCallAnalyticsProcessor")
 *                     .amazonTranscribeCallAnalyticsProcessorConfiguration(MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs.builder()
 *                         .languageCode("en-US")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("KinesisDataStreamSink")
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(exampleStream.arn())
 *                         .build())
 *                     .build())
 *             .build());
 *         var defaultVoiceConnectorStreaming = new VoiceConnectorStreaming("defaultVoiceConnectorStreaming", VoiceConnectorStreamingArgs.builder()
 *             .disabled(false)
 *             .voiceConnectorId(default_.id())
 *             .dataRetention(7)
 *             .streamingNotificationTargets("SQS")
 *             .mediaInsightsConfiguration(VoiceConnectorStreamingMediaInsightsConfigurationArgs.builder()
 *                 .disabled(false)
 *                 .configurationArn(example.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:chime:VoiceConnector
 *     properties:
 *       name: vc-name-test
 *       requireEncryption: true
 *   defaultVoiceConnectorStreaming:
 *     type: aws:chime:VoiceConnectorStreaming
 *     name: default
 *     properties:
 *       disabled: false
 *       voiceConnectorId: ${default.id}
 *       dataRetention: 7
 *       streamingNotificationTargets:
 *         - SQS
 *       mediaInsightsConfiguration:
 *         disabled: false
 *         configurationArn: ${example.arn}
 *   example:
 *     type: aws:chimesdkmediapipelines:MediaInsightsPipelineConfiguration
 *     properties:
 *       name: ExampleConfig
 *       resourceAccessRoleArn: ${exampleRole.arn}
 *       elements:
 *         - type: AmazonTranscribeCallAnalyticsProcessor
 *           amazonTranscribeCallAnalyticsProcessorConfiguration:
 *             languageCode: en-US
 *         - type: KinesisDataStreamSink
 *           kinesisDataStreamSinkConfiguration:
 *             insightsTarget: ${exampleStream.arn}
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: ExampleResourceAccessRole
 *       assumeRolePolicy: ${assumeRole.json}
 *   exampleStream:
 *     type: aws:kinesis:Stream
 *     name: example
 *     properties:
 *       name: ExampleStream
 *       shardCount: 2
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - mediapipelines.chime.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Chime Voice Connector Streaming using the `voice_connector_id`. For example:
 * ```sh
 * $ pulumi import aws:chime/voiceConnectorStreaming:VoiceConnectorStreaming default abcdef1ghij2klmno3pqr4
 * ```
 * @property dataRetention The retention period, in hours, for the Amazon Kinesis data.
 * @property disabled When true, media streaming to Amazon Kinesis is turned off. Default: `false`
 * @property mediaInsightsConfiguration The media insights configuration. See `media_insights_configuration`.
 * @property streamingNotificationTargets The streaming notification targets. Valid Values: `EventBridge | SNS | SQS`
 * @property voiceConnectorId The Amazon Chime Voice Connector ID.
 */
public data class VoiceConnectorStreamingArgs(
    public val dataRetention: Output<Int>? = null,
    public val disabled: Output<Boolean>? = null,
    public val mediaInsightsConfiguration: Output<VoiceConnectorStreamingMediaInsightsConfigurationArgs>? = null,
    public val streamingNotificationTargets: Output<List<String>>? = null,
    public val voiceConnectorId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.VoiceConnectorStreamingArgs> {
    override fun toJava(): com.pulumi.aws.chime.VoiceConnectorStreamingArgs =
        com.pulumi.aws.chime.VoiceConnectorStreamingArgs.builder()
            .dataRetention(dataRetention?.applyValue({ args0 -> args0 }))
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .mediaInsightsConfiguration(
                mediaInsightsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .streamingNotificationTargets(
                streamingNotificationTargets?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .voiceConnectorId(voiceConnectorId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VoiceConnectorStreamingArgs].
 */
@PulumiTagMarker
public class VoiceConnectorStreamingArgsBuilder internal constructor() {
    private var dataRetention: Output<Int>? = null

    private var disabled: Output<Boolean>? = null

    private var mediaInsightsConfiguration:
        Output<VoiceConnectorStreamingMediaInsightsConfigurationArgs>? = null

    private var streamingNotificationTargets: Output<List<String>>? = null

    private var voiceConnectorId: Output<String>? = null

    /**
     * @param value The retention period, in hours, for the Amazon Kinesis data.
     */
    @JvmName("padaypgglmepbdoh")
    public suspend fun dataRetention(`value`: Output<Int>) {
        this.dataRetention = value
    }

    /**
     * @param value When true, media streaming to Amazon Kinesis is turned off. Default: `false`
     */
    @JvmName("omngntusrhecgghd")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value The media insights configuration. See `media_insights_configuration`.
     */
    @JvmName("nkdewymyygmnrrcs")
    public suspend fun mediaInsightsConfiguration(`value`: Output<VoiceConnectorStreamingMediaInsightsConfigurationArgs>) {
        this.mediaInsightsConfiguration = value
    }

    /**
     * @param value The streaming notification targets. Valid Values: `EventBridge | SNS | SQS`
     */
    @JvmName("bvquoetemopjuocd")
    public suspend fun streamingNotificationTargets(`value`: Output<List<String>>) {
        this.streamingNotificationTargets = value
    }

    @JvmName("ngkvtiguqvyacqag")
    public suspend fun streamingNotificationTargets(vararg values: Output<String>) {
        this.streamingNotificationTargets = Output.all(values.asList())
    }

    /**
     * @param values The streaming notification targets. Valid Values: `EventBridge | SNS | SQS`
     */
    @JvmName("vtllnkcgckqqaopv")
    public suspend fun streamingNotificationTargets(values: List<Output<String>>) {
        this.streamingNotificationTargets = Output.all(values)
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("owqnewiiiqsoisik")
    public suspend fun voiceConnectorId(`value`: Output<String>) {
        this.voiceConnectorId = value
    }

    /**
     * @param value The retention period, in hours, for the Amazon Kinesis data.
     */
    @JvmName("tsioxmshrxcxfhbh")
    public suspend fun dataRetention(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataRetention = mapped
    }

    /**
     * @param value When true, media streaming to Amazon Kinesis is turned off. Default: `false`
     */
    @JvmName("pekmkeljfyioalmo")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value The media insights configuration. See `media_insights_configuration`.
     */
    @JvmName("ouapwvvftpnofkcp")
    public suspend fun mediaInsightsConfiguration(`value`: VoiceConnectorStreamingMediaInsightsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaInsightsConfiguration = mapped
    }

    /**
     * @param argument The media insights configuration. See `media_insights_configuration`.
     */
    @JvmName("aceualwbbncbuhlc")
    public suspend fun mediaInsightsConfiguration(argument: suspend VoiceConnectorStreamingMediaInsightsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VoiceConnectorStreamingMediaInsightsConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.mediaInsightsConfiguration = mapped
    }

    /**
     * @param value The streaming notification targets. Valid Values: `EventBridge | SNS | SQS`
     */
    @JvmName("kfiyvdvntfaaxxel")
    public suspend fun streamingNotificationTargets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamingNotificationTargets = mapped
    }

    /**
     * @param values The streaming notification targets. Valid Values: `EventBridge | SNS | SQS`
     */
    @JvmName("ycxrrqsfmfbvkjjq")
    public suspend fun streamingNotificationTargets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamingNotificationTargets = mapped
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("nlqrbleqohhxvavn")
    public suspend fun voiceConnectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceConnectorId = mapped
    }

    internal fun build(): VoiceConnectorStreamingArgs = VoiceConnectorStreamingArgs(
        dataRetention = dataRetention,
        disabled = disabled,
        mediaInsightsConfiguration = mediaInsightsConfiguration,
        streamingNotificationTargets = streamingNotificationTargets,
        voiceConnectorId = voiceConnectorId,
    )
}
