@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.VoiceConnectorTerminationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Enable Termination settings to control outbound calling from your SIP infrastructure.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.chime.VoiceConnector("default", {
 *     name: "vc-name-test",
 *     requireEncryption: true,
 * });
 * const defaultVoiceConnectorTermination = new aws.chime.VoiceConnectorTermination("default", {
 *     disabled: false,
 *     cpsLimit: 1,
 *     cidrAllowLists: ["50&#46;35&#46;78&#46;96/31"],
 *     callingRegions: [
 *         "US",
 *         "CA",
 *     ],
 *     voiceConnectorId: _default.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.chime.VoiceConnector("default",
 *     name="vc-name-test",
 *     require_encryption=True)
 * default_voice_connector_termination = aws.chime.VoiceConnectorTermination("default",
 *     disabled=False,
 *     cps_limit=1,
 *     cidr_allow_lists=["50&#46;35&#46;78&#46;96/31"],
 *     calling_regions=[
 *         "US",
 *         "CA",
 *     ],
 *     voice_connector_id=default.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Chime.VoiceConnector("default", new()
 *     {
 *         Name = "vc-name-test",
 *         RequireEncryption = true,
 *     });
 *     var defaultVoiceConnectorTermination = new Aws.Chime.VoiceConnectorTermination("default", new()
 *     {
 *         Disabled = false,
 *         CpsLimit = 1,
 *         CidrAllowLists = new[]
 *         {
 *             "50.35.78.96/31",
 *         },
 *         CallingRegions = new[]
 *         {
 *             "US",
 *             "CA",
 *         },
 *         VoiceConnectorId = @default.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chime"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chime.NewVoiceConnector(ctx, "default", &chime.VoiceConnectorArgs{
 * 			Name:              pulumi.String("vc-name-test"),
 * 			RequireEncryption: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = chime.NewVoiceConnectorTermination(ctx, "default", &chime.VoiceConnectorTerminationArgs{
 * 			Disabled: pulumi.Bool(false),
 * 			CpsLimit: pulumi.Int(1),
 * 			CidrAllowLists: pulumi.StringArray{
 * 				pulumi.String("50.35.78.96/31"),
 * 			},
 * 			CallingRegions: pulumi.StringArray{
 * 				pulumi.String("US"),
 * 				pulumi.String("CA"),
 * 			},
 * 			VoiceConnectorId: _default.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorTermination;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new VoiceConnector("default", VoiceConnectorArgs.builder()
 *             .name("vc-name-test")
 *             .requireEncryption(true)
 *             .build());
 *         var defaultVoiceConnectorTermination = new VoiceConnectorTermination("defaultVoiceConnectorTermination", VoiceConnectorTerminationArgs.builder()
 *             .disabled(false)
 *             .cpsLimit(1)
 *             .cidrAllowLists("50.35.78.96/31")
 *             .callingRegions(
 *                 "US",
 *                 "CA")
 *             .voiceConnectorId(default_.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:chime:VoiceConnector
 *     properties:
 *       name: vc-name-test
 *       requireEncryption: true
 *   defaultVoiceConnectorTermination:
 *     type: aws:chime:VoiceConnectorTermination
 *     name: default
 *     properties:
 *       disabled: false
 *       cpsLimit: 1
 *       cidrAllowLists:
 *         - 50.35.78.96/31
 *       callingRegions:
 *         - US
 *         - CA
 *       voiceConnectorId: ${default.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Chime Voice Connector Termination using the `voice_connector_id`. For example:
 * ```sh
 * $ pulumi import aws:chime/voiceConnectorTermination:VoiceConnectorTermination default abcdef1ghij2klmno3pqr4
 * ```
 * @property callingRegions The countries to which calls are allowed, in ISO 3166-1 alpha-2 format.
 * @property cidrAllowLists The IP addresses allowed to make calls, in CIDR format.
 * @property cpsLimit The limit on calls per second. Max value based on account service quota. Default value of `1`.
 * @property defaultPhoneNumber The default caller ID phone number.
 * @property disabled When termination settings are disabled, outbound calls can not be made.
 * @property voiceConnectorId The Amazon Chime Voice Connector ID.
 */
public data class VoiceConnectorTerminationArgs(
    public val callingRegions: Output<List<String>>? = null,
    public val cidrAllowLists: Output<List<String>>? = null,
    public val cpsLimit: Output<Int>? = null,
    public val defaultPhoneNumber: Output<String>? = null,
    public val disabled: Output<Boolean>? = null,
    public val voiceConnectorId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.VoiceConnectorTerminationArgs> {
    override fun toJava(): com.pulumi.aws.chime.VoiceConnectorTerminationArgs =
        com.pulumi.aws.chime.VoiceConnectorTerminationArgs.builder()
            .callingRegions(callingRegions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cidrAllowLists(cidrAllowLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cpsLimit(cpsLimit?.applyValue({ args0 -> args0 }))
            .defaultPhoneNumber(defaultPhoneNumber?.applyValue({ args0 -> args0 }))
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .voiceConnectorId(voiceConnectorId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VoiceConnectorTerminationArgs].
 */
@PulumiTagMarker
public class VoiceConnectorTerminationArgsBuilder internal constructor() {
    private var callingRegions: Output<List<String>>? = null

    private var cidrAllowLists: Output<List<String>>? = null

    private var cpsLimit: Output<Int>? = null

    private var defaultPhoneNumber: Output<String>? = null

    private var disabled: Output<Boolean>? = null

    private var voiceConnectorId: Output<String>? = null

    /**
     * @param value The countries to which calls are allowed, in ISO 3166-1 alpha-2 format.
     */
    @JvmName("hymxelryvlhqklxs")
    public suspend fun callingRegions(`value`: Output<List<String>>) {
        this.callingRegions = value
    }

    @JvmName("mkmgipthqxjxgkdg")
    public suspend fun callingRegions(vararg values: Output<String>) {
        this.callingRegions = Output.all(values.asList())
    }

    /**
     * @param values The countries to which calls are allowed, in ISO 3166-1 alpha-2 format.
     */
    @JvmName("ojfmbwkxbbylioun")
    public suspend fun callingRegions(values: List<Output<String>>) {
        this.callingRegions = Output.all(values)
    }

    /**
     * @param value The IP addresses allowed to make calls, in CIDR format.
     */
    @JvmName("bhghuwqynyxsdlkv")
    public suspend fun cidrAllowLists(`value`: Output<List<String>>) {
        this.cidrAllowLists = value
    }

    @JvmName("rrejqiamgmvforkh")
    public suspend fun cidrAllowLists(vararg values: Output<String>) {
        this.cidrAllowLists = Output.all(values.asList())
    }

    /**
     * @param values The IP addresses allowed to make calls, in CIDR format.
     */
    @JvmName("agdoxlvmqowkcfwg")
    public suspend fun cidrAllowLists(values: List<Output<String>>) {
        this.cidrAllowLists = Output.all(values)
    }

    /**
     * @param value The limit on calls per second. Max value based on account service quota. Default value of `1`.
     */
    @JvmName("wtputkpftdqweuox")
    public suspend fun cpsLimit(`value`: Output<Int>) {
        this.cpsLimit = value
    }

    /**
     * @param value The default caller ID phone number.
     */
    @JvmName("eqlvdevavowidttn")
    public suspend fun defaultPhoneNumber(`value`: Output<String>) {
        this.defaultPhoneNumber = value
    }

    /**
     * @param value When termination settings are disabled, outbound calls can not be made.
     */
    @JvmName("yiyxwtwminkvwolv")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("hlucymlxtxeytijk")
    public suspend fun voiceConnectorId(`value`: Output<String>) {
        this.voiceConnectorId = value
    }

    /**
     * @param value The countries to which calls are allowed, in ISO 3166-1 alpha-2 format.
     */
    @JvmName("amnqrevyonherpbl")
    public suspend fun callingRegions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callingRegions = mapped
    }

    /**
     * @param values The countries to which calls are allowed, in ISO 3166-1 alpha-2 format.
     */
    @JvmName("bewnmdrtbpcewyyu")
    public suspend fun callingRegions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.callingRegions = mapped
    }

    /**
     * @param value The IP addresses allowed to make calls, in CIDR format.
     */
    @JvmName("kpekwofcbjvxbbit")
    public suspend fun cidrAllowLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrAllowLists = mapped
    }

    /**
     * @param values The IP addresses allowed to make calls, in CIDR format.
     */
    @JvmName("kqeuqsadyfmvjqiu")
    public suspend fun cidrAllowLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrAllowLists = mapped
    }

    /**
     * @param value The limit on calls per second. Max value based on account service quota. Default value of `1`.
     */
    @JvmName("fsyaipeaqedeqqmm")
    public suspend fun cpsLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpsLimit = mapped
    }

    /**
     * @param value The default caller ID phone number.
     */
    @JvmName("sbvuslgevgwjvrqn")
    public suspend fun defaultPhoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultPhoneNumber = mapped
    }

    /**
     * @param value When termination settings are disabled, outbound calls can not be made.
     */
    @JvmName("emmyfhnanjrshutu")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("mbsbysckbesoofve")
    public suspend fun voiceConnectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceConnectorId = mapped
    }

    internal fun build(): VoiceConnectorTerminationArgs = VoiceConnectorTerminationArgs(
        callingRegions = callingRegions,
        cidrAllowLists = cidrAllowLists,
        cpsLimit = cpsLimit,
        defaultPhoneNumber = defaultPhoneNumber,
        disabled = disabled,
        voiceConnectorId = voiceConnectorId,
    )
}
