@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.kotlin.outputs.VoiceConnectorTerminationCredentialsCredential
import com.pulumi.aws.chime.kotlin.outputs.VoiceConnectorTerminationCredentialsCredential.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VoiceConnectorTerminationCredentials].
 */
@PulumiTagMarker
public class VoiceConnectorTerminationCredentialsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VoiceConnectorTerminationCredentialsArgs =
        VoiceConnectorTerminationCredentialsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VoiceConnectorTerminationCredentialsArgsBuilder.() -> Unit) {
        val builder = VoiceConnectorTerminationCredentialsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VoiceConnectorTerminationCredentials {
        val builtJavaResource =
            com.pulumi.aws.chime.VoiceConnectorTerminationCredentials(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VoiceConnectorTerminationCredentials(builtJavaResource)
    }
}

/**
 * Adds termination SIP credentials for the specified Amazon Chime Voice Connector.
 * > **Note:** Voice Connector Termination Credentials requires a Voice Connector Termination to be present. Use of `depends_on` (as shown below) is recommended to avoid race conditions.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.chime.VoiceConnector("default", {
 *     name: "test",
 *     requireEncryption: true,
 * });
 * const defaultVoiceConnectorTermination = new aws.chime.VoiceConnectorTermination("default", {
 *     disabled: true,
 *     cpsLimit: 1,
 *     cidrAllowLists: ["50&#46;35&#46;78&#46;96/31"],
 *     callingRegions: [
 *         "US",
 *         "CA",
 *     ],
 *     voiceConnectorId: _default.id,
 * });
 * const defaultVoiceConnectorTerminationCredentials = new aws.chime.VoiceConnectorTerminationCredentials("default", {
 *     voiceConnectorId: _default.id,
 *     credentials: [{
 *         username: "test",
 *         password: "test!",
 *     }],
 * }, {
 *     dependsOn: [defaultVoiceConnectorTermination],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.chime.VoiceConnector("default",
 *     name="test",
 *     require_encryption=True)
 * default_voice_connector_termination = aws.chime.VoiceConnectorTermination("default",
 *     disabled=True,
 *     cps_limit=1,
 *     cidr_allow_lists=["50&#46;35&#46;78&#46;96/31"],
 *     calling_regions=[
 *         "US",
 *         "CA",
 *     ],
 *     voice_connector_id=default.id)
 * default_voice_connector_termination_credentials = aws.chime.VoiceConnectorTerminationCredentials("default",
 *     voice_connector_id=default.id,
 *     credentials=[{
 *         "username": "test",
 *         "password": "test!",
 *     }],
 *     opts = pulumi.ResourceOptions(depends_on=[default_voice_connector_termination]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Chime.VoiceConnector("default", new()
 *     {
 *         Name = "test",
 *         RequireEncryption = true,
 *     });
 *     var defaultVoiceConnectorTermination = new Aws.Chime.VoiceConnectorTermination("default", new()
 *     {
 *         Disabled = true,
 *         CpsLimit = 1,
 *         CidrAllowLists = new[]
 *         {
 *             "50.35.78.96/31",
 *         },
 *         CallingRegions = new[]
 *         {
 *             "US",
 *             "CA",
 *         },
 *         VoiceConnectorId = @default.Id,
 *     });
 *     var defaultVoiceConnectorTerminationCredentials = new Aws.Chime.VoiceConnectorTerminationCredentials("default", new()
 *     {
 *         VoiceConnectorId = @default.Id,
 *         Credentials = new[]
 *         {
 *             new Aws.Chime.Inputs.VoiceConnectorTerminationCredentialsCredentialArgs
 *             {
 *                 Username = "test",
 *                 Password = "test!",
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             defaultVoiceConnectorTermination,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chime"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chime.NewVoiceConnector(ctx, "default", &chime.VoiceConnectorArgs{
 * 			Name:              pulumi.String("test"),
 * 			RequireEncryption: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVoiceConnectorTermination, err := chime.NewVoiceConnectorTermination(ctx, "default", &chime.VoiceConnectorTerminationArgs{
 * 			Disabled: pulumi.Bool(true),
 * 			CpsLimit: pulumi.Int(1),
 * 			CidrAllowLists: pulumi.StringArray{
 * 				pulumi.String("50.35.78.96/31"),
 * 			},
 * 			CallingRegions: pulumi.StringArray{
 * 				pulumi.String("US"),
 * 				pulumi.String("CA"),
 * 			},
 * 			VoiceConnectorId: _default.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = chime.NewVoiceConnectorTerminationCredentials(ctx, "default", &chime.VoiceConnectorTerminationCredentialsArgs{
 * 			VoiceConnectorId: _default.ID(),
 * 			Credentials: chime.VoiceConnectorTerminationCredentialsCredentialArray{
 * 				&chime.VoiceConnectorTerminationCredentialsCredentialArgs{
 * 					Username: pulumi.String("test"),
 * 					Password: pulumi.String("test!"),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			defaultVoiceConnectorTermination,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorTermination;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationArgs;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationCredentials;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationCredentialsArgs;
 * import com.pulumi.aws.chime.inputs.VoiceConnectorTerminationCredentialsCredentialArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new VoiceConnector("default", VoiceConnectorArgs.builder()
 *             .name("test")
 *             .requireEncryption(true)
 *             .build());
 *         var defaultVoiceConnectorTermination = new VoiceConnectorTermination("defaultVoiceConnectorTermination", VoiceConnectorTerminationArgs.builder()
 *             .disabled(true)
 *             .cpsLimit(1)
 *             .cidrAllowLists("50.35.78.96/31")
 *             .callingRegions(
 *                 "US",
 *                 "CA")
 *             .voiceConnectorId(default_.id())
 *             .build());
 *         var defaultVoiceConnectorTerminationCredentials = new VoiceConnectorTerminationCredentials("defaultVoiceConnectorTerminationCredentials", VoiceConnectorTerminationCredentialsArgs.builder()
 *             .voiceConnectorId(default_.id())
 *             .credentials(VoiceConnectorTerminationCredentialsCredentialArgs.builder()
 *                 .username("test")
 *                 .password("test!")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(defaultVoiceConnectorTermination)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:chime:VoiceConnector
 *     properties:
 *       name: test
 *       requireEncryption: true
 *   defaultVoiceConnectorTermination:
 *     type: aws:chime:VoiceConnectorTermination
 *     name: default
 *     properties:
 *       disabled: true
 *       cpsLimit: 1
 *       cidrAllowLists:
 *         - 50.35.78.96/31
 *       callingRegions:
 *         - US
 *         - CA
 *       voiceConnectorId: ${default.id}
 *   defaultVoiceConnectorTerminationCredentials:
 *     type: aws:chime:VoiceConnectorTerminationCredentials
 *     name: default
 *     properties:
 *       voiceConnectorId: ${default.id}
 *       credentials:
 *         - username: test
 *           password: test!
 *     options:
 *       dependson:
 *         - ${defaultVoiceConnectorTermination}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Chime Voice Connector Termination Credentials using the `voice_connector_id`. For example:
 * ```sh
 * $ pulumi import aws:chime/voiceConnectorTerminationCredentials:VoiceConnectorTerminationCredentials default abcdef1ghij2klmno3pqr4
 * ```
 */
public class VoiceConnectorTerminationCredentials internal constructor(
    override val javaResource: com.pulumi.aws.chime.VoiceConnectorTerminationCredentials,
) : KotlinCustomResource(javaResource, VoiceConnectorTerminationCredentialsMapper) {
    /**
     * List of termination SIP credentials.
     */
    public val credentials: Output<List<VoiceConnectorTerminationCredentialsCredential>>
        get() = javaResource.credentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Amazon Chime Voice Connector ID.
     */
    public val voiceConnectorId: Output<String>
        get() = javaResource.voiceConnectorId().applyValue({ args0 -> args0 })
}

public object VoiceConnectorTerminationCredentialsMapper :
    ResourceMapper<VoiceConnectorTerminationCredentials> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.chime.VoiceConnectorTerminationCredentials::class == javaResource::class

    override fun map(javaResource: Resource): VoiceConnectorTerminationCredentials =
        VoiceConnectorTerminationCredentials(
            javaResource as
                com.pulumi.aws.chime.VoiceConnectorTerminationCredentials,
        )
}

/**
 * @see [VoiceConnectorTerminationCredentials].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VoiceConnectorTerminationCredentials].
 */
public suspend fun voiceConnectorTerminationCredentials(
    name: String,
    block: suspend VoiceConnectorTerminationCredentialsResourceBuilder.() -> Unit,
): VoiceConnectorTerminationCredentials {
    val builder = VoiceConnectorTerminationCredentialsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VoiceConnectorTerminationCredentials].
 * @param name The _unique_ name of the resulting resource.
 */
public fun voiceConnectorTerminationCredentials(name: String): VoiceConnectorTerminationCredentials {
    val builder = VoiceConnectorTerminationCredentialsResourceBuilder()
    builder.name(name)
    return builder.build()
}
