@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.VoiceConnectorTerminationCredentialsArgs.builder
import com.pulumi.aws.chime.kotlin.inputs.VoiceConnectorTerminationCredentialsCredentialArgs
import com.pulumi.aws.chime.kotlin.inputs.VoiceConnectorTerminationCredentialsCredentialArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Adds termination SIP credentials for the specified Amazon Chime Voice Connector.
 * > **Note:** Voice Connector Termination Credentials requires a Voice Connector Termination to be present. Use of `depends_on` (as shown below) is recommended to avoid race conditions.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.chime.VoiceConnector("default", {
 *     name: "test",
 *     requireEncryption: true,
 * });
 * const defaultVoiceConnectorTermination = new aws.chime.VoiceConnectorTermination("default", {
 *     disabled: true,
 *     cpsLimit: 1,
 *     cidrAllowLists: ["50&#46;35&#46;78&#46;96/31"],
 *     callingRegions: [
 *         "US",
 *         "CA",
 *     ],
 *     voiceConnectorId: _default.id,
 * });
 * const defaultVoiceConnectorTerminationCredentials = new aws.chime.VoiceConnectorTerminationCredentials("default", {
 *     voiceConnectorId: _default.id,
 *     credentials: [{
 *         username: "test",
 *         password: "test!",
 *     }],
 * }, {
 *     dependsOn: [defaultVoiceConnectorTermination],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.chime.VoiceConnector("default",
 *     name="test",
 *     require_encryption=True)
 * default_voice_connector_termination = aws.chime.VoiceConnectorTermination("default",
 *     disabled=True,
 *     cps_limit=1,
 *     cidr_allow_lists=["50&#46;35&#46;78&#46;96/31"],
 *     calling_regions=[
 *         "US",
 *         "CA",
 *     ],
 *     voice_connector_id=default.id)
 * default_voice_connector_termination_credentials = aws.chime.VoiceConnectorTerminationCredentials("default",
 *     voice_connector_id=default.id,
 *     credentials=[{
 *         "username": "test",
 *         "password": "test!",
 *     }],
 *     opts = pulumi.ResourceOptions(depends_on=[default_voice_connector_termination]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Chime.VoiceConnector("default", new()
 *     {
 *         Name = "test",
 *         RequireEncryption = true,
 *     });
 *     var defaultVoiceConnectorTermination = new Aws.Chime.VoiceConnectorTermination("default", new()
 *     {
 *         Disabled = true,
 *         CpsLimit = 1,
 *         CidrAllowLists = new[]
 *         {
 *             "50.35.78.96/31",
 *         },
 *         CallingRegions = new[]
 *         {
 *             "US",
 *             "CA",
 *         },
 *         VoiceConnectorId = @default.Id,
 *     });
 *     var defaultVoiceConnectorTerminationCredentials = new Aws.Chime.VoiceConnectorTerminationCredentials("default", new()
 *     {
 *         VoiceConnectorId = @default.Id,
 *         Credentials = new[]
 *         {
 *             new Aws.Chime.Inputs.VoiceConnectorTerminationCredentialsCredentialArgs
 *             {
 *                 Username = "test",
 *                 Password = "test!",
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             defaultVoiceConnectorTermination,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chime"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chime.NewVoiceConnector(ctx, "default", &chime.VoiceConnectorArgs{
 * 			Name:              pulumi.String("test"),
 * 			RequireEncryption: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVoiceConnectorTermination, err := chime.NewVoiceConnectorTermination(ctx, "default", &chime.VoiceConnectorTerminationArgs{
 * 			Disabled: pulumi.Bool(true),
 * 			CpsLimit: pulumi.Int(1),
 * 			CidrAllowLists: pulumi.StringArray{
 * 				pulumi.String("50.35.78.96/31"),
 * 			},
 * 			CallingRegions: pulumi.StringArray{
 * 				pulumi.String("US"),
 * 				pulumi.String("CA"),
 * 			},
 * 			VoiceConnectorId: _default.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = chime.NewVoiceConnectorTerminationCredentials(ctx, "default", &chime.VoiceConnectorTerminationCredentialsArgs{
 * 			VoiceConnectorId: _default.ID(),
 * 			Credentials: chime.VoiceConnectorTerminationCredentialsCredentialArray{
 * 				&chime.VoiceConnectorTerminationCredentialsCredentialArgs{
 * 					Username: pulumi.String("test"),
 * 					Password: pulumi.String("test!"),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			defaultVoiceConnectorTermination,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorTermination;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationArgs;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationCredentials;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationCredentialsArgs;
 * import com.pulumi.aws.chime.inputs.VoiceConnectorTerminationCredentialsCredentialArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new VoiceConnector("default", VoiceConnectorArgs.builder()
 *             .name("test")
 *             .requireEncryption(true)
 *             .build());
 *         var defaultVoiceConnectorTermination = new VoiceConnectorTermination("defaultVoiceConnectorTermination", VoiceConnectorTerminationArgs.builder()
 *             .disabled(true)
 *             .cpsLimit(1)
 *             .cidrAllowLists("50.35.78.96/31")
 *             .callingRegions(
 *                 "US",
 *                 "CA")
 *             .voiceConnectorId(default_.id())
 *             .build());
 *         var defaultVoiceConnectorTerminationCredentials = new VoiceConnectorTerminationCredentials("defaultVoiceConnectorTerminationCredentials", VoiceConnectorTerminationCredentialsArgs.builder()
 *             .voiceConnectorId(default_.id())
 *             .credentials(VoiceConnectorTerminationCredentialsCredentialArgs.builder()
 *                 .username("test")
 *                 .password("test!")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(defaultVoiceConnectorTermination)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:chime:VoiceConnector
 *     properties:
 *       name: test
 *       requireEncryption: true
 *   defaultVoiceConnectorTermination:
 *     type: aws:chime:VoiceConnectorTermination
 *     name: default
 *     properties:
 *       disabled: true
 *       cpsLimit: 1
 *       cidrAllowLists:
 *         - 50.35.78.96/31
 *       callingRegions:
 *         - US
 *         - CA
 *       voiceConnectorId: ${default.id}
 *   defaultVoiceConnectorTerminationCredentials:
 *     type: aws:chime:VoiceConnectorTerminationCredentials
 *     name: default
 *     properties:
 *       voiceConnectorId: ${default.id}
 *       credentials:
 *         - username: test
 *           password: test!
 *     options:
 *       dependson:
 *         - ${defaultVoiceConnectorTermination}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Chime Voice Connector Termination Credentials using the `voice_connector_id`. For example:
 * ```sh
 * $ pulumi import aws:chime/voiceConnectorTerminationCredentials:VoiceConnectorTerminationCredentials default abcdef1ghij2klmno3pqr4
 * ```
 * @property credentials List of termination SIP credentials.
 * @property voiceConnectorId Amazon Chime Voice Connector ID.
 */
public data class VoiceConnectorTerminationCredentialsArgs(
    public val credentials: Output<List<VoiceConnectorTerminationCredentialsCredentialArgs>>? = null,
    public val voiceConnectorId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.VoiceConnectorTerminationCredentialsArgs> {
    override fun toJava(): com.pulumi.aws.chime.VoiceConnectorTerminationCredentialsArgs =
        com.pulumi.aws.chime.VoiceConnectorTerminationCredentialsArgs.builder()
            .credentials(
                credentials?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .voiceConnectorId(voiceConnectorId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VoiceConnectorTerminationCredentialsArgs].
 */
@PulumiTagMarker
public class VoiceConnectorTerminationCredentialsArgsBuilder internal constructor() {
    private var credentials: Output<List<VoiceConnectorTerminationCredentialsCredentialArgs>>? = null

    private var voiceConnectorId: Output<String>? = null

    /**
     * @param value List of termination SIP credentials.
     */
    @JvmName("vucocoixqjlrbcvy")
    public suspend fun credentials(`value`: Output<List<VoiceConnectorTerminationCredentialsCredentialArgs>>) {
        this.credentials = value
    }

    @JvmName("bsgfxfddhesjpaum")
    public suspend fun credentials(vararg values: Output<VoiceConnectorTerminationCredentialsCredentialArgs>) {
        this.credentials = Output.all(values.asList())
    }

    /**
     * @param values List of termination SIP credentials.
     */
    @JvmName("hjcjnnasqjdrspku")
    public suspend fun credentials(values: List<Output<VoiceConnectorTerminationCredentialsCredentialArgs>>) {
        this.credentials = Output.all(values)
    }

    /**
     * @param value Amazon Chime Voice Connector ID.
     */
    @JvmName("pirqmxflbkneutiv")
    public suspend fun voiceConnectorId(`value`: Output<String>) {
        this.voiceConnectorId = value
    }

    /**
     * @param value List of termination SIP credentials.
     */
    @JvmName("mruweglinvmiabkl")
    public suspend fun credentials(`value`: List<VoiceConnectorTerminationCredentialsCredentialArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument List of termination SIP credentials.
     */
    @JvmName("peojqopdowpxrcww")
    public suspend fun credentials(argument: List<suspend VoiceConnectorTerminationCredentialsCredentialArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VoiceConnectorTerminationCredentialsCredentialArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param argument List of termination SIP credentials.
     */
    @JvmName("paemjobpgihsqtis")
    public suspend fun credentials(vararg argument: suspend VoiceConnectorTerminationCredentialsCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VoiceConnectorTerminationCredentialsCredentialArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param argument List of termination SIP credentials.
     */
    @JvmName("tupbhxmqkvtmsfyp")
    public suspend fun credentials(argument: suspend VoiceConnectorTerminationCredentialsCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VoiceConnectorTerminationCredentialsCredentialArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param values List of termination SIP credentials.
     */
    @JvmName("pwedyhdyuyujdqxv")
    public suspend fun credentials(vararg values: VoiceConnectorTerminationCredentialsCredentialArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param value Amazon Chime Voice Connector ID.
     */
    @JvmName("qfucvkyxkaqioqjg")
    public suspend fun voiceConnectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceConnectorId = mapped
    }

    internal fun build(): VoiceConnectorTerminationCredentialsArgs =
        VoiceConnectorTerminationCredentialsArgs(
            credentials = credentials,
            voiceConnectorId = voiceConnectorId,
        )
}
