@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin.inputs

import com.pulumi.aws.chime.inputs.SdkvoiceGlobalSettingsVoiceConnectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cdrBucket The S3 bucket that stores the Voice Connector's call detail records.
 */
public data class SdkvoiceGlobalSettingsVoiceConnectorArgs(
    public val cdrBucket: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.inputs.SdkvoiceGlobalSettingsVoiceConnectorArgs> {
    override fun toJava(): com.pulumi.aws.chime.inputs.SdkvoiceGlobalSettingsVoiceConnectorArgs =
        com.pulumi.aws.chime.inputs.SdkvoiceGlobalSettingsVoiceConnectorArgs.builder()
            .cdrBucket(cdrBucket?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SdkvoiceGlobalSettingsVoiceConnectorArgs].
 */
@PulumiTagMarker
public class SdkvoiceGlobalSettingsVoiceConnectorArgsBuilder internal constructor() {
    private var cdrBucket: Output<String>? = null

    /**
     * @param value The S3 bucket that stores the Voice Connector's call detail records.
     */
    @JvmName("kjaomrxjytrayudd")
    public suspend fun cdrBucket(`value`: Output<String>) {
        this.cdrBucket = value
    }

    /**
     * @param value The S3 bucket that stores the Voice Connector's call detail records.
     */
    @JvmName("hepnqeykvinvbufe")
    public suspend fun cdrBucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdrBucket = mapped
    }

    internal fun build(): SdkvoiceGlobalSettingsVoiceConnectorArgs =
        SdkvoiceGlobalSettingsVoiceConnectorArgs(
            cdrBucket = cdrBucket,
        )
}
