@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin.inputs

import com.pulumi.aws.chime.inputs.SdkvoiceSipRuleTargetApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property awsRegion The AWS Region of the target application.
 * @property priority Priority of the SIP media application in the target list.
 * @property sipMediaApplicationId The SIP media application ID.
 */
public data class SdkvoiceSipRuleTargetApplicationArgs(
    public val awsRegion: Output<String>,
    public val priority: Output<Int>,
    public val sipMediaApplicationId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.chime.inputs.SdkvoiceSipRuleTargetApplicationArgs> {
    override fun toJava(): com.pulumi.aws.chime.inputs.SdkvoiceSipRuleTargetApplicationArgs =
        com.pulumi.aws.chime.inputs.SdkvoiceSipRuleTargetApplicationArgs.builder()
            .awsRegion(awsRegion.applyValue({ args0 -> args0 }))
            .priority(priority.applyValue({ args0 -> args0 }))
            .sipMediaApplicationId(sipMediaApplicationId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SdkvoiceSipRuleTargetApplicationArgs].
 */
@PulumiTagMarker
public class SdkvoiceSipRuleTargetApplicationArgsBuilder internal constructor() {
    private var awsRegion: Output<String>? = null

    private var priority: Output<Int>? = null

    private var sipMediaApplicationId: Output<String>? = null

    /**
     * @param value The AWS Region of the target application.
     */
    @JvmName("byduduqfrjwosiqf")
    public suspend fun awsRegion(`value`: Output<String>) {
        this.awsRegion = value
    }

    /**
     * @param value Priority of the SIP media application in the target list.
     */
    @JvmName("yuxakporifysnmnf")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The SIP media application ID.
     */
    @JvmName("cypoyagtiylqxxbi")
    public suspend fun sipMediaApplicationId(`value`: Output<String>) {
        this.sipMediaApplicationId = value
    }

    /**
     * @param value The AWS Region of the target application.
     */
    @JvmName("wuklqnkwljrtwexj")
    public suspend fun awsRegion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.awsRegion = mapped
    }

    /**
     * @param value Priority of the SIP media application in the target list.
     */
    @JvmName("cqujxlwbvkaiwfrr")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The SIP media application ID.
     */
    @JvmName("oliabvbscyxdkohx")
    public suspend fun sipMediaApplicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sipMediaApplicationId = mapped
    }

    internal fun build(): SdkvoiceSipRuleTargetApplicationArgs = SdkvoiceSipRuleTargetApplicationArgs(
        awsRegion = awsRegion ?: throw PulumiNullFieldException("awsRegion"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
        sipMediaApplicationId = sipMediaApplicationId ?: throw
            PulumiNullFieldException("sipMediaApplicationId"),
    )
}
