@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin.inputs

import com.pulumi.aws.chime.inputs.VoiceConnectorGroupConnectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property priority The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher priority Amazon Chime Voice Connectors are attempted first.
 * @property voiceConnectorId The Amazon Chime Voice Connector ID.
 */
public data class VoiceConnectorGroupConnectorArgs(
    public val priority: Output<Int>,
    public val voiceConnectorId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.chime.inputs.VoiceConnectorGroupConnectorArgs> {
    override fun toJava(): com.pulumi.aws.chime.inputs.VoiceConnectorGroupConnectorArgs =
        com.pulumi.aws.chime.inputs.VoiceConnectorGroupConnectorArgs.builder()
            .priority(priority.applyValue({ args0 -> args0 }))
            .voiceConnectorId(voiceConnectorId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VoiceConnectorGroupConnectorArgs].
 */
@PulumiTagMarker
public class VoiceConnectorGroupConnectorArgsBuilder internal constructor() {
    private var priority: Output<Int>? = null

    private var voiceConnectorId: Output<String>? = null

    /**
     * @param value The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher priority Amazon Chime Voice Connectors are attempted first.
     */
    @JvmName("oxxjtvppibmgvflv")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("qhxccoykacuyrlev")
    public suspend fun voiceConnectorId(`value`: Output<String>) {
        this.voiceConnectorId = value
    }

    /**
     * @param value The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher priority Amazon Chime Voice Connectors are attempted first.
     */
    @JvmName("msolagftebvvdisx")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("xrbpnvtgkpllexkg")
    public suspend fun voiceConnectorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.voiceConnectorId = mapped
    }

    internal fun build(): VoiceConnectorGroupConnectorArgs = VoiceConnectorGroupConnectorArgs(
        priority = priority ?: throw PulumiNullFieldException("priority"),
        voiceConnectorId = voiceConnectorId ?: throw PulumiNullFieldException("voiceConnectorId"),
    )
}
