@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin.inputs

import com.pulumi.aws.chime.inputs.VoiceConnectorOrganizationRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property host The FQDN or IP address to contact for origination traffic.
 * @property port The designated origination route port. Defaults to `5060`.
 * @property priority The priority associated with the host, with 1 being the highest priority. Higher priority hosts are attempted first.
 * @property protocol The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.
 * @property weight The weight associated with the host. If hosts are equal in priority, calls are redistributed among them based on their relative weight.
 */
public data class VoiceConnectorOrganizationRouteArgs(
    public val host: Output<String>,
    public val port: Output<Int>? = null,
    public val priority: Output<Int>,
    public val protocol: Output<String>,
    public val weight: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.chime.inputs.VoiceConnectorOrganizationRouteArgs> {
    override fun toJava(): com.pulumi.aws.chime.inputs.VoiceConnectorOrganizationRouteArgs =
        com.pulumi.aws.chime.inputs.VoiceConnectorOrganizationRouteArgs.builder()
            .host(host.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .priority(priority.applyValue({ args0 -> args0 }))
            .protocol(protocol.applyValue({ args0 -> args0 }))
            .weight(weight.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VoiceConnectorOrganizationRouteArgs].
 */
@PulumiTagMarker
public class VoiceConnectorOrganizationRouteArgsBuilder internal constructor() {
    private var host: Output<String>? = null

    private var port: Output<Int>? = null

    private var priority: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The FQDN or IP address to contact for origination traffic.
     */
    @JvmName("ktnydoxelojxpbws")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value The designated origination route port. Defaults to `5060`.
     */
    @JvmName("rjgjetnuvqgftpoi")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The priority associated with the host, with 1 being the highest priority. Higher priority hosts are attempted first.
     */
    @JvmName("tekmfsnffpqrmcit")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.
     */
    @JvmName("txcndmnosbqqfctr")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The weight associated with the host. If hosts are equal in priority, calls are redistributed among them based on their relative weight.
     */
    @JvmName("wdknfisttmymfaix")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The FQDN or IP address to contact for origination traffic.
     */
    @JvmName("qwtndyxogyfpofgu")
    public suspend fun host(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The designated origination route port. Defaults to `5060`.
     */
    @JvmName("aebdloxunabxhdou")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The priority associated with the host, with 1 being the highest priority. Higher priority hosts are attempted first.
     */
    @JvmName("ysnhnducegxcarrs")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.
     */
    @JvmName("tarvwoavblkhyruu")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The weight associated with the host. If hosts are equal in priority, calls are redistributed among them based on their relative weight.
     */
    @JvmName("ldpdgccxncynfggx")
    public suspend fun weight(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): VoiceConnectorOrganizationRouteArgs = VoiceConnectorOrganizationRouteArgs(
        host = host ?: throw PulumiNullFieldException("host"),
        port = port,
        priority = priority ?: throw PulumiNullFieldException("priority"),
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
        weight = weight ?: throw PulumiNullFieldException("weight"),
    )
}
