@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin.inputs

import com.pulumi.aws.chime.inputs.VoiceConnectorTerminationCredentialsCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property password RFC2617 compliant password associated with the SIP credentials.
 * @property username RFC2617 compliant username associated with the SIP credentials.
 */
public data class VoiceConnectorTerminationCredentialsCredentialArgs(
    public val password: Output<String>,
    public val username: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.chime.inputs.VoiceConnectorTerminationCredentialsCredentialArgs> {
    override fun toJava(): com.pulumi.aws.chime.inputs.VoiceConnectorTerminationCredentialsCredentialArgs =
        com.pulumi.aws.chime.inputs.VoiceConnectorTerminationCredentialsCredentialArgs.builder()
            .password(password.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VoiceConnectorTerminationCredentialsCredentialArgs].
 */
@PulumiTagMarker
public class VoiceConnectorTerminationCredentialsCredentialArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value RFC2617 compliant password associated with the SIP credentials.
     */
    @JvmName("rbqrgqpbrkltlrnm")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value RFC2617 compliant username associated with the SIP credentials.
     */
    @JvmName("xniubaepctlhrosi")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value RFC2617 compliant password associated with the SIP credentials.
     */
    @JvmName("fhjnxiiegcobrarh")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value RFC2617 compliant username associated with the SIP credentials.
     */
    @JvmName("knlytoihuuokkekr")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): VoiceConnectorTerminationCredentialsCredentialArgs =
        VoiceConnectorTerminationCredentialsCredentialArgs(
            password = password ?: throw PulumiNullFieldException("password"),
            username = username ?: throw PulumiNullFieldException("username"),
        )
}
