@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property awsRegion The AWS Region of the target application.
 * @property priority Priority of the SIP media application in the target list.
 * @property sipMediaApplicationId The SIP media application ID.
 */
public data class SdkvoiceSipRuleTargetApplication(
    public val awsRegion: String,
    public val priority: Int,
    public val sipMediaApplicationId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.chime.outputs.SdkvoiceSipRuleTargetApplication): SdkvoiceSipRuleTargetApplication = SdkvoiceSipRuleTargetApplication(
            awsRegion = javaType.awsRegion(),
            priority = javaType.priority(),
            sipMediaApplicationId = javaType.sipMediaApplicationId(),
        )
    }
}
