@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property priority The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher priority Amazon Chime Voice Connectors are attempted first.
 * @property voiceConnectorId The Amazon Chime Voice Connector ID.
 */
public data class VoiceConnectorGroupConnector(
    public val priority: Int,
    public val voiceConnectorId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.chime.outputs.VoiceConnectorGroupConnector): VoiceConnectorGroupConnector = VoiceConnectorGroupConnector(
            priority = javaType.priority(),
            voiceConnectorId = javaType.voiceConnectorId(),
        )
    }
}
