@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property password RFC2617 compliant password associated with the SIP credentials.
 * @property username RFC2617 compliant username associated with the SIP credentials.
 */
public data class VoiceConnectorTerminationCredentialsCredential(
    public val password: String,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.chime.outputs.VoiceConnectorTerminationCredentialsCredential): VoiceConnectorTerminationCredentialsCredential =
            VoiceConnectorTerminationCredentialsCredential(
                password = javaType.password(),
                username = javaType.username(),
            )
    }
}
