@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs

import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property callAnalyticsStreamCategories Filter for category events to be delivered to insights target.
 * @property contentIdentificationType Labels all personally identifiable information (PII) identified in Utterance events.
 * @property contentRedactionType Redacts all personally identifiable information (PII) identified in Utterance events.
 * @property enablePartialResultsStabilization Enables partial result stabilization in Utterance events.
 * @property filterPartialResults Filters partial Utterance events from delivery to the insights target.
 * @property languageCode Language code for the transcription model.
 * @property languageModelName Name of custom language model for transcription.
 * @property partialResultsStability Level of stability to use when partial results stabilization is enabled.
 * @property piiEntityTypes Types of personally identifiable information (PII) to redact from an Utterance event.
 * @property postCallAnalyticsSettings Settings for post call analytics.
 * @property vocabularyFilterMethod Method for applying a vocabulary filter to Utterance events.
 * @property vocabularyFilterName Name of the custom vocabulary filter to use when processing Utterance events.
 * @property vocabularyName Name of the custom vocabulary to use when processing Utterance events.
 */
public data class
MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs(
    public val callAnalyticsStreamCategories: Output<List<String>>? = null,
    public val contentIdentificationType: Output<String>? = null,
    public val contentRedactionType: Output<String>? = null,
    public val enablePartialResultsStabilization: Output<Boolean>? = null,
    public val filterPartialResults: Output<Boolean>? = null,
    public val languageCode: Output<String>,
    public val languageModelName: Output<String>? = null,
    public val partialResultsStability: Output<String>? = null,
    public val piiEntityTypes: Output<String>? = null,
    public val postCallAnalyticsSettings: Output<MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs>? =
        null,
    public val vocabularyFilterMethod: Output<String>? = null,
    public val vocabularyFilterName: Output<String>? = null,
    public val vocabularyName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs =
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs.builder()
            .callAnalyticsStreamCategories(
                callAnalyticsStreamCategories?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .contentIdentificationType(contentIdentificationType?.applyValue({ args0 -> args0 }))
            .contentRedactionType(contentRedactionType?.applyValue({ args0 -> args0 }))
            .enablePartialResultsStabilization(
                enablePartialResultsStabilization?.applyValue({ args0 ->
                    args0
                }),
            )
            .filterPartialResults(filterPartialResults?.applyValue({ args0 -> args0 }))
            .languageCode(languageCode.applyValue({ args0 -> args0 }))
            .languageModelName(languageModelName?.applyValue({ args0 -> args0 }))
            .partialResultsStability(partialResultsStability?.applyValue({ args0 -> args0 }))
            .piiEntityTypes(piiEntityTypes?.applyValue({ args0 -> args0 }))
            .postCallAnalyticsSettings(
                postCallAnalyticsSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vocabularyFilterMethod(vocabularyFilterMethod?.applyValue({ args0 -> args0 }))
            .vocabularyFilterName(vocabularyFilterName?.applyValue({ args0 -> args0 }))
            .vocabularyName(vocabularyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs].
 */
@PulumiTagMarker
public class
MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgsBuilder
internal constructor() {
    private var callAnalyticsStreamCategories: Output<List<String>>? = null

    private var contentIdentificationType: Output<String>? = null

    private var contentRedactionType: Output<String>? = null

    private var enablePartialResultsStabilization: Output<Boolean>? = null

    private var filterPartialResults: Output<Boolean>? = null

    private var languageCode: Output<String>? = null

    private var languageModelName: Output<String>? = null

    private var partialResultsStability: Output<String>? = null

    private var piiEntityTypes: Output<String>? = null

    private var postCallAnalyticsSettings:
        Output<MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs>? =
        null

    private var vocabularyFilterMethod: Output<String>? = null

    private var vocabularyFilterName: Output<String>? = null

    private var vocabularyName: Output<String>? = null

    /**
     * @param value Filter for category events to be delivered to insights target.
     */
    @JvmName("sjbjbtlhdswpljmp")
    public suspend fun callAnalyticsStreamCategories(`value`: Output<List<String>>) {
        this.callAnalyticsStreamCategories = value
    }

    @JvmName("pjfajojunbvkldxn")
    public suspend fun callAnalyticsStreamCategories(vararg values: Output<String>) {
        this.callAnalyticsStreamCategories = Output.all(values.asList())
    }

    /**
     * @param values Filter for category events to be delivered to insights target.
     */
    @JvmName("vjedpkevgivgaass")
    public suspend fun callAnalyticsStreamCategories(values: List<Output<String>>) {
        this.callAnalyticsStreamCategories = Output.all(values)
    }

    /**
     * @param value Labels all personally identifiable information (PII) identified in Utterance events.
     */
    @JvmName("hpcsnhpguplcjxjm")
    public suspend fun contentIdentificationType(`value`: Output<String>) {
        this.contentIdentificationType = value
    }

    /**
     * @param value Redacts all personally identifiable information (PII) identified in Utterance events.
     */
    @JvmName("mforxwnjgrdonvkr")
    public suspend fun contentRedactionType(`value`: Output<String>) {
        this.contentRedactionType = value
    }

    /**
     * @param value Enables partial result stabilization in Utterance events.
     */
    @JvmName("hyywajjjijhovrap")
    public suspend fun enablePartialResultsStabilization(`value`: Output<Boolean>) {
        this.enablePartialResultsStabilization = value
    }

    /**
     * @param value Filters partial Utterance events from delivery to the insights target.
     */
    @JvmName("gbqgtajslqypcnoi")
    public suspend fun filterPartialResults(`value`: Output<Boolean>) {
        this.filterPartialResults = value
    }

    /**
     * @param value Language code for the transcription model.
     */
    @JvmName("pnjfhoejrwvuvrjb")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value Name of custom language model for transcription.
     */
    @JvmName("momayuwdeiixmrlh")
    public suspend fun languageModelName(`value`: Output<String>) {
        this.languageModelName = value
    }

    /**
     * @param value Level of stability to use when partial results stabilization is enabled.
     */
    @JvmName("gxggnubvgrtrlcxq")
    public suspend fun partialResultsStability(`value`: Output<String>) {
        this.partialResultsStability = value
    }

    /**
     * @param value Types of personally identifiable information (PII) to redact from an Utterance event.
     */
    @JvmName("ukqflikbmaetskby")
    public suspend fun piiEntityTypes(`value`: Output<String>) {
        this.piiEntityTypes = value
    }

    /**
     * @param value Settings for post call analytics.
     */
    @JvmName("tybpbaemwmotctot")
    public suspend fun postCallAnalyticsSettings(`value`: Output<MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs>) {
        this.postCallAnalyticsSettings = value
    }

    /**
     * @param value Method for applying a vocabulary filter to Utterance events.
     */
    @JvmName("ypojmyeqqwptlatk")
    public suspend fun vocabularyFilterMethod(`value`: Output<String>) {
        this.vocabularyFilterMethod = value
    }

    /**
     * @param value Name of the custom vocabulary filter to use when processing Utterance events.
     */
    @JvmName("gjwvesjmbjalcnyi")
    public suspend fun vocabularyFilterName(`value`: Output<String>) {
        this.vocabularyFilterName = value
    }

    /**
     * @param value Name of the custom vocabulary to use when processing Utterance events.
     */
    @JvmName("ytlvqrluanwgljou")
    public suspend fun vocabularyName(`value`: Output<String>) {
        this.vocabularyName = value
    }

    /**
     * @param value Filter for category events to be delivered to insights target.
     */
    @JvmName("tlquhbdglyirmqyi")
    public suspend fun callAnalyticsStreamCategories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callAnalyticsStreamCategories = mapped
    }

    /**
     * @param values Filter for category events to be delivered to insights target.
     */
    @JvmName("oukcyjkkdspkxufl")
    public suspend fun callAnalyticsStreamCategories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.callAnalyticsStreamCategories = mapped
    }

    /**
     * @param value Labels all personally identifiable information (PII) identified in Utterance events.
     */
    @JvmName("cqifbuipfsrhjnnj")
    public suspend fun contentIdentificationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentIdentificationType = mapped
    }

    /**
     * @param value Redacts all personally identifiable information (PII) identified in Utterance events.
     */
    @JvmName("pxlndqhgwberlaqj")
    public suspend fun contentRedactionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentRedactionType = mapped
    }

    /**
     * @param value Enables partial result stabilization in Utterance events.
     */
    @JvmName("uymhpdsjqhhblxkg")
    public suspend fun enablePartialResultsStabilization(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePartialResultsStabilization = mapped
    }

    /**
     * @param value Filters partial Utterance events from delivery to the insights target.
     */
    @JvmName("rcofpteicihbinkb")
    public suspend fun filterPartialResults(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterPartialResults = mapped
    }

    /**
     * @param value Language code for the transcription model.
     */
    @JvmName("howdpgmcqrhtrona")
    public suspend fun languageCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value Name of custom language model for transcription.
     */
    @JvmName("wovuahpxhoitubcv")
    public suspend fun languageModelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageModelName = mapped
    }

    /**
     * @param value Level of stability to use when partial results stabilization is enabled.
     */
    @JvmName("vpkgfjkphgqaugsf")
    public suspend fun partialResultsStability(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partialResultsStability = mapped
    }

    /**
     * @param value Types of personally identifiable information (PII) to redact from an Utterance event.
     */
    @JvmName("idcdidskuunppgby")
    public suspend fun piiEntityTypes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.piiEntityTypes = mapped
    }

    /**
     * @param value Settings for post call analytics.
     */
    @JvmName("tdrckigflvfaxavg")
    public suspend fun postCallAnalyticsSettings(`value`: MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postCallAnalyticsSettings = mapped
    }

    /**
     * @param argument Settings for post call analytics.
     */
    @JvmName("xoqwgxhjavkoobgv")
    public suspend fun postCallAnalyticsSettings(argument: suspend MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.postCallAnalyticsSettings = mapped
    }

    /**
     * @param value Method for applying a vocabulary filter to Utterance events.
     */
    @JvmName("yakupioljessqwnq")
    public suspend fun vocabularyFilterMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vocabularyFilterMethod = mapped
    }

    /**
     * @param value Name of the custom vocabulary filter to use when processing Utterance events.
     */
    @JvmName("dakerevthcanhikr")
    public suspend fun vocabularyFilterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vocabularyFilterName = mapped
    }

    /**
     * @param value Name of the custom vocabulary to use when processing Utterance events.
     */
    @JvmName("uwffbtheibgfuelm")
    public suspend fun vocabularyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vocabularyName = mapped
    }

    internal fun build(): MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs =
        MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs(
            callAnalyticsStreamCategories = callAnalyticsStreamCategories,
            contentIdentificationType = contentIdentificationType,
            contentRedactionType = contentRedactionType,
            enablePartialResultsStabilization = enablePartialResultsStabilization,
            filterPartialResults = filterPartialResults,
            languageCode = languageCode ?: throw PulumiNullFieldException("languageCode"),
            languageModelName = languageModelName,
            partialResultsStability = partialResultsStability,
            piiEntityTypes = piiEntityTypes,
            postCallAnalyticsSettings = postCallAnalyticsSettings,
            vocabularyFilterMethod = vocabularyFilterMethod,
            vocabularyFilterName = vocabularyFilterName,
            vocabularyName = vocabularyName,
        )
}
