@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs

import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property amazonTranscribeCallAnalyticsProcessorConfiguration Configuration for Amazon Transcribe Call Analytics processor.
 * @property amazonTranscribeProcessorConfiguration Configuration for Amazon Transcribe processor.
 * @property kinesisDataStreamSinkConfiguration Configuration for Kinesis Data Stream sink.
 * @property lambdaFunctionSinkConfiguration Configuration for Lambda Function sink.
 * @property s3RecordingSinkConfiguration Configuration for S3 recording sink.
 * @property snsTopicSinkConfiguration Configuration for SNS Topic sink.
 * @property sqsQueueSinkConfiguration Configuration for SQS Queue sink.
 * @property type Element type.
 * @property voiceAnalyticsProcessorConfiguration Configuration for Voice analytics processor.
 */
public data class MediaInsightsPipelineConfigurationElementArgs(
    public val amazonTranscribeCallAnalyticsProcessorConfiguration: Output<MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs>? =
        null,
    public val amazonTranscribeProcessorConfiguration: Output<MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs>? =
        null,
    public val kinesisDataStreamSinkConfiguration: Output<MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs>? =
        null,
    public val lambdaFunctionSinkConfiguration: Output<MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs>? = null,
    public val s3RecordingSinkConfiguration: Output<MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs>? = null,
    public val snsTopicSinkConfiguration: Output<MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs>? = null,
    public val sqsQueueSinkConfiguration: Output<MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs>? = null,
    public val type: Output<String>,
    public val voiceAnalyticsProcessorConfiguration: Output<MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs> {
    override fun toJava(): com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs =
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs.builder()
            .amazonTranscribeCallAnalyticsProcessorConfiguration(
                amazonTranscribeCallAnalyticsProcessorConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .amazonTranscribeProcessorConfiguration(
                amazonTranscribeProcessorConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .kinesisDataStreamSinkConfiguration(
                kinesisDataStreamSinkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .lambdaFunctionSinkConfiguration(
                lambdaFunctionSinkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .s3RecordingSinkConfiguration(
                s3RecordingSinkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .snsTopicSinkConfiguration(
                snsTopicSinkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sqsQueueSinkConfiguration(
                sqsQueueSinkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .voiceAnalyticsProcessorConfiguration(
                voiceAnalyticsProcessorConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [MediaInsightsPipelineConfigurationElementArgs].
 */
@PulumiTagMarker
public class MediaInsightsPipelineConfigurationElementArgsBuilder internal constructor() {
    private var amazonTranscribeCallAnalyticsProcessorConfiguration:
        Output<MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs>? =
        null

    private var amazonTranscribeProcessorConfiguration:
        Output<MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs>? =
        null

    private var kinesisDataStreamSinkConfiguration:
        Output<MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs>? =
        null

    private var lambdaFunctionSinkConfiguration:
        Output<MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs>? = null

    private var s3RecordingSinkConfiguration:
        Output<MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs>? = null

    private var snsTopicSinkConfiguration:
        Output<MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs>? = null

    private var sqsQueueSinkConfiguration:
        Output<MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs>? = null

    private var type: Output<String>? = null

    private var voiceAnalyticsProcessorConfiguration:
        Output<MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs>? =
        null

    /**
     * @param value Configuration for Amazon Transcribe Call Analytics processor.
     */
    @JvmName("temivbjvetpbwspr")
    public suspend fun amazonTranscribeCallAnalyticsProcessorConfiguration(`value`: Output<MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs>) {
        this.amazonTranscribeCallAnalyticsProcessorConfiguration = value
    }

    /**
     * @param value Configuration for Amazon Transcribe processor.
     */
    @JvmName("ojvaadfyaytfempd")
    public suspend fun amazonTranscribeProcessorConfiguration(`value`: Output<MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs>) {
        this.amazonTranscribeProcessorConfiguration = value
    }

    /**
     * @param value Configuration for Kinesis Data Stream sink.
     */
    @JvmName("bmwqkijjblcycthl")
    public suspend fun kinesisDataStreamSinkConfiguration(`value`: Output<MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs>) {
        this.kinesisDataStreamSinkConfiguration = value
    }

    /**
     * @param value Configuration for Lambda Function sink.
     */
    @JvmName("vlkexeveekevyawh")
    public suspend fun lambdaFunctionSinkConfiguration(`value`: Output<MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs>) {
        this.lambdaFunctionSinkConfiguration = value
    }

    /**
     * @param value Configuration for S3 recording sink.
     */
    @JvmName("dnwiuyjphmjfqkmt")
    public suspend fun s3RecordingSinkConfiguration(`value`: Output<MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs>) {
        this.s3RecordingSinkConfiguration = value
    }

    /**
     * @param value Configuration for SNS Topic sink.
     */
    @JvmName("vvdfyowwluruuqyo")
    public suspend fun snsTopicSinkConfiguration(`value`: Output<MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs>) {
        this.snsTopicSinkConfiguration = value
    }

    /**
     * @param value Configuration for SQS Queue sink.
     */
    @JvmName("nincnjkfnsqtrsqd")
    public suspend fun sqsQueueSinkConfiguration(`value`: Output<MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs>) {
        this.sqsQueueSinkConfiguration = value
    }

    /**
     * @param value Element type.
     */
    @JvmName("faelpqshngjkbdmc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Configuration for Voice analytics processor.
     */
    @JvmName("yaegunuqruvmorwf")
    public suspend fun voiceAnalyticsProcessorConfiguration(`value`: Output<MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs>) {
        this.voiceAnalyticsProcessorConfiguration = value
    }

    /**
     * @param value Configuration for Amazon Transcribe Call Analytics processor.
     */
    @JvmName("blidbxhhiteiwuen")
    public suspend fun amazonTranscribeCallAnalyticsProcessorConfiguration(`value`: MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amazonTranscribeCallAnalyticsProcessorConfiguration = mapped
    }

    /**
     * @param argument Configuration for Amazon Transcribe Call Analytics processor.
     */
    @JvmName("hdrbjtttclehsgqn")
    public suspend fun amazonTranscribeCallAnalyticsProcessorConfiguration(argument: suspend MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.amazonTranscribeCallAnalyticsProcessorConfiguration = mapped
    }

    /**
     * @param value Configuration for Amazon Transcribe processor.
     */
    @JvmName("ftygjdorlgnbngkr")
    public suspend fun amazonTranscribeProcessorConfiguration(`value`: MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amazonTranscribeProcessorConfiguration = mapped
    }

    /**
     * @param argument Configuration for Amazon Transcribe processor.
     */
    @JvmName("dfqjqqbgxjfgjaya")
    public suspend fun amazonTranscribeProcessorConfiguration(argument: suspend MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.amazonTranscribeProcessorConfiguration = mapped
    }

    /**
     * @param value Configuration for Kinesis Data Stream sink.
     */
    @JvmName("yksbeihduljpjsfn")
    public suspend fun kinesisDataStreamSinkConfiguration(`value`: MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisDataStreamSinkConfiguration = mapped
    }

    /**
     * @param argument Configuration for Kinesis Data Stream sink.
     */
    @JvmName("vctaxschtnpdanhy")
    public suspend fun kinesisDataStreamSinkConfiguration(argument: suspend MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.kinesisDataStreamSinkConfiguration = mapped
    }

    /**
     * @param value Configuration for Lambda Function sink.
     */
    @JvmName("qfqhxbldxwnujrsm")
    public suspend fun lambdaFunctionSinkConfiguration(`value`: MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaFunctionSinkConfiguration = mapped
    }

    /**
     * @param argument Configuration for Lambda Function sink.
     */
    @JvmName("ifebqurlebexbriu")
    public suspend fun lambdaFunctionSinkConfiguration(argument: suspend MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.lambdaFunctionSinkConfiguration = mapped
    }

    /**
     * @param value Configuration for S3 recording sink.
     */
    @JvmName("dsocmkixkgeuenuq")
    public suspend fun s3RecordingSinkConfiguration(`value`: MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3RecordingSinkConfiguration = mapped
    }

    /**
     * @param argument Configuration for S3 recording sink.
     */
    @JvmName("kmkjsxcersnruenc")
    public suspend fun s3RecordingSinkConfiguration(argument: suspend MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3RecordingSinkConfiguration = mapped
    }

    /**
     * @param value Configuration for SNS Topic sink.
     */
    @JvmName("exivwjacqutiklim")
    public suspend fun snsTopicSinkConfiguration(`value`: MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopicSinkConfiguration = mapped
    }

    /**
     * @param argument Configuration for SNS Topic sink.
     */
    @JvmName("bmekyhfcjxljrbiv")
    public suspend fun snsTopicSinkConfiguration(argument: suspend MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.snsTopicSinkConfiguration = mapped
    }

    /**
     * @param value Configuration for SQS Queue sink.
     */
    @JvmName("eynhtmspsotlufvw")
    public suspend fun sqsQueueSinkConfiguration(`value`: MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqsQueueSinkConfiguration = mapped
    }

    /**
     * @param argument Configuration for SQS Queue sink.
     */
    @JvmName("anppkqqraehohmyi")
    public suspend fun sqsQueueSinkConfiguration(argument: suspend MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sqsQueueSinkConfiguration = mapped
    }

    /**
     * @param value Element type.
     */
    @JvmName("ruamoibmwbriswxj")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Configuration for Voice analytics processor.
     */
    @JvmName("ymvpsniqsqoptyak")
    public suspend fun voiceAnalyticsProcessorConfiguration(`value`: MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceAnalyticsProcessorConfiguration = mapped
    }

    /**
     * @param argument Configuration for Voice analytics processor.
     */
    @JvmName("clukkxjfyjjsliun")
    public suspend fun voiceAnalyticsProcessorConfiguration(argument: suspend MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.voiceAnalyticsProcessorConfiguration = mapped
    }

    internal fun build(): MediaInsightsPipelineConfigurationElementArgs =
        MediaInsightsPipelineConfigurationElementArgs(
            amazonTranscribeCallAnalyticsProcessorConfiguration = amazonTranscribeCallAnalyticsProcessorConfiguration,
            amazonTranscribeProcessorConfiguration = amazonTranscribeProcessorConfiguration,
            kinesisDataStreamSinkConfiguration = kinesisDataStreamSinkConfiguration,
            lambdaFunctionSinkConfiguration = lambdaFunctionSinkConfiguration,
            s3RecordingSinkConfiguration = s3RecordingSinkConfiguration,
            snsTopicSinkConfiguration = snsTopicSinkConfiguration,
            sqsQueueSinkConfiguration = sqsQueueSinkConfiguration,
            type = type ?: throw PulumiNullFieldException("type"),
            voiceAnalyticsProcessorConfiguration = voiceAnalyticsProcessorConfiguration,
        )
}
