@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs

import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property insightsTarget Lambda Function to deliver results.
 */
public data class MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs(
    public val insightsTarget: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs =
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs.builder()
            .insightsTarget(insightsTarget.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs].
 */
@PulumiTagMarker
public class MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgsBuilder
internal constructor() {
    private var insightsTarget: Output<String>? = null

    /**
     * @param value Lambda Function to deliver results.
     */
    @JvmName("wteuiviogsjfcebc")
    public suspend fun insightsTarget(`value`: Output<String>) {
        this.insightsTarget = value
    }

    /**
     * @param value Lambda Function to deliver results.
     */
    @JvmName("puyttyumpowxenir")
    public suspend fun insightsTarget(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insightsTarget = mapped
    }

    internal fun build(): MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs = MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs(
        insightsTarget = insightsTarget ?: throw PulumiNullFieldException("insightsTarget"),
    )
}
