@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs

import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property insightsTarget SNS topic to deliver results.
 */
public data class MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs(
    public val insightsTarget: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs =
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs.builder()
            .insightsTarget(insightsTarget.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs].
 */
@PulumiTagMarker
public class MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgsBuilder internal constructor() {
    private var insightsTarget: Output<String>? = null

    /**
     * @param value SNS topic to deliver results.
     */
    @JvmName("gecdrqmkgxyfslxc")
    public suspend fun insightsTarget(`value`: Output<String>) {
        this.insightsTarget = value
    }

    /**
     * @param value SNS topic to deliver results.
     */
    @JvmName("akuybgtekbiahhhq")
    public suspend fun insightsTarget(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insightsTarget = mapped
    }

    internal fun build(): MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs =
        MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs(
            insightsTarget = insightsTarget ?: throw PulumiNullFieldException("insightsTarget"),
        )
}
