@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs

import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property insightsTarget SQS queue to deliver results.
 */
public data class MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs(
    public val insightsTarget: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs =
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs.builder()
            .insightsTarget(insightsTarget.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs].
 */
@PulumiTagMarker
public class MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgsBuilder internal constructor() {
    private var insightsTarget: Output<String>? = null

    /**
     * @param value SQS queue to deliver results.
     */
    @JvmName("rxhbwigsiejaqcsv")
    public suspend fun insightsTarget(`value`: Output<String>) {
        this.insightsTarget = value
    }

    /**
     * @param value SQS queue to deliver results.
     */
    @JvmName("iauwelabbclsbnel")
    public suspend fun insightsTarget(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insightsTarget = mapped
    }

    internal fun build(): MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs =
        MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs(
            insightsTarget = insightsTarget ?: throw PulumiNullFieldException("insightsTarget"),
        )
}
