@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs

import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property speakerSearchStatus Enable speaker search.
 * @property voiceToneAnalysisStatus Enable voice tone analysis.
 */
public data class MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs(
    public val speakerSearchStatus: Output<String>,
    public val voiceToneAnalysisStatus: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs =
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs.builder()
            .speakerSearchStatus(speakerSearchStatus.applyValue({ args0 -> args0 }))
            .voiceToneAnalysisStatus(voiceToneAnalysisStatus.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs].
 */
@PulumiTagMarker
public class
MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgsBuilder
internal constructor() {
    private var speakerSearchStatus: Output<String>? = null

    private var voiceToneAnalysisStatus: Output<String>? = null

    /**
     * @param value Enable speaker search.
     */
    @JvmName("nyiamropuwmvvgka")
    public suspend fun speakerSearchStatus(`value`: Output<String>) {
        this.speakerSearchStatus = value
    }

    /**
     * @param value Enable voice tone analysis.
     */
    @JvmName("gjwofxpinxovufvo")
    public suspend fun voiceToneAnalysisStatus(`value`: Output<String>) {
        this.voiceToneAnalysisStatus = value
    }

    /**
     * @param value Enable speaker search.
     */
    @JvmName("vykjukrbjpeinoxc")
    public suspend fun speakerSearchStatus(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.speakerSearchStatus = mapped
    }

    /**
     * @param value Enable voice tone analysis.
     */
    @JvmName("pwhvrtcmbypdhwag")
    public suspend fun voiceToneAnalysisStatus(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.voiceToneAnalysisStatus = mapped
    }

    internal fun build(): MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs =
        MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs(
            speakerSearchStatus = speakerSearchStatus ?: throw PulumiNullFieldException("speakerSearchStatus"),
            voiceToneAnalysisStatus = voiceToneAnalysisStatus ?: throw
                PulumiNullFieldException("voiceToneAnalysisStatus"),
        )
}
