@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs

import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property disabled Disables real time alert rules.
 * @property rules Collection of real time alert rules
 */
public data class MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs(
    public val disabled: Output<Boolean>? = null,
    public val rules: Output<List<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs =
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs.builder()
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .rules(
                rules.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs].
 */
@PulumiTagMarker
public class MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgsBuilder internal constructor() {
    private var disabled: Output<Boolean>? = null

    private var rules:
        Output<List<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs>>? = null

    /**
     * @param value Disables real time alert rules.
     */
    @JvmName("wiwgvwrqpefamhnf")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value Collection of real time alert rules
     */
    @JvmName("npkfkueuexjgafjp")
    public suspend fun rules(`value`: Output<List<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs>>) {
        this.rules = value
    }

    @JvmName("qymhqceodpwsclce")
    public suspend fun rules(vararg values: Output<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Collection of real time alert rules
     */
    @JvmName("xvmkrwtxqvmgjrss")
    public suspend fun rules(values: List<Output<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Disables real time alert rules.
     */
    @JvmName("rcjjjnjrxqsvsxwo")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value Collection of real time alert rules
     */
    @JvmName("yjlfmwaaamcipkri")
    public suspend fun rules(`value`: List<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Collection of real time alert rules
     */
    @JvmName("afrolvpxnwhgakuk")
    public suspend fun rules(argument: List<suspend MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Collection of real time alert rules
     */
    @JvmName("ctudipejsopwpweg")
    public suspend fun rules(vararg argument: suspend MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Collection of real time alert rules
     */
    @JvmName("xmiwqlntvqqbexjt")
    public suspend fun rules(argument: suspend MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Collection of real time alert rules
     */
    @JvmName("iduluqphgwmefhlp")
    public suspend fun rules(vararg values: MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs =
        MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs(
            disabled = disabled,
            rules = rules ?: throw PulumiNullFieldException("rules"),
        )
}
