@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property amazonTranscribeCallAnalyticsProcessorConfiguration Configuration for Amazon Transcribe Call Analytics processor.
 * @property amazonTranscribeProcessorConfiguration Configuration for Amazon Transcribe processor.
 * @property kinesisDataStreamSinkConfiguration Configuration for Kinesis Data Stream sink.
 * @property lambdaFunctionSinkConfiguration Configuration for Lambda Function sink.
 * @property s3RecordingSinkConfiguration Configuration for S3 recording sink.
 * @property snsTopicSinkConfiguration Configuration for SNS Topic sink.
 * @property sqsQueueSinkConfiguration Configuration for SQS Queue sink.
 * @property type Element type.
 * @property voiceAnalyticsProcessorConfiguration Configuration for Voice analytics processor.
 */
public data class MediaInsightsPipelineConfigurationElement(
    public val amazonTranscribeCallAnalyticsProcessorConfiguration: MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfiguration? =
        null,
    public val amazonTranscribeProcessorConfiguration: MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfiguration? = null,
    public val kinesisDataStreamSinkConfiguration: MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfiguration? = null,
    public val lambdaFunctionSinkConfiguration: MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfiguration? = null,
    public val s3RecordingSinkConfiguration: MediaInsightsPipelineConfigurationElementS3RecordingSinkConfiguration? = null,
    public val snsTopicSinkConfiguration: MediaInsightsPipelineConfigurationElementSnsTopicSinkConfiguration? = null,
    public val sqsQueueSinkConfiguration: MediaInsightsPipelineConfigurationElementSqsQueueSinkConfiguration? = null,
    public val type: String,
    public val voiceAnalyticsProcessorConfiguration: MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.chimesdkmediapipelines.outputs.MediaInsightsPipelineConfigurationElement): MediaInsightsPipelineConfigurationElement = MediaInsightsPipelineConfigurationElement(
            amazonTranscribeCallAnalyticsProcessorConfiguration = javaType.amazonTranscribeCallAnalyticsProcessorConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            amazonTranscribeProcessorConfiguration = javaType.amazonTranscribeProcessorConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kinesisDataStreamSinkConfiguration = javaType.kinesisDataStreamSinkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lambdaFunctionSinkConfiguration = javaType.lambdaFunctionSinkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs.MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3RecordingSinkConfiguration = javaType.s3RecordingSinkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs.MediaInsightsPipelineConfigurationElementS3RecordingSinkConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            snsTopicSinkConfiguration = javaType.snsTopicSinkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs.MediaInsightsPipelineConfigurationElementSnsTopicSinkConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sqsQueueSinkConfiguration = javaType.sqsQueueSinkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs.MediaInsightsPipelineConfigurationElementSqsQueueSinkConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            voiceAnalyticsProcessorConfiguration = javaType.voiceAnalyticsProcessorConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs.MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
