@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property contentRedactionOutput Should output be redacted.
 * @property dataAccessRoleArn ARN of the role used by AWS Transcribe to upload your post call analysis.
 * @property outputEncryptionKmsKeyId ID of the KMS key used to encrypt the output.
 * @property outputLocation The Amazon S3 location where you want your Call Analytics post-call transcription output stored.
 */
public data class
MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettings(
    public val contentRedactionOutput: String? = null,
    public val dataAccessRoleArn: String,
    public val outputEncryptionKmsKeyId: String? = null,
    public val outputLocation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.chimesdkmediapipelines.outputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettings): MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettings =
            MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettings(
                contentRedactionOutput = javaType.contentRedactionOutput().map({ args0 -> args0 }).orElse(null),
                dataAccessRoleArn = javaType.dataAccessRoleArn(),
                outputEncryptionKmsKeyId = javaType.outputEncryptionKmsKeyId().map({ args0 -> args0 }).orElse(null),
                outputLocation = javaType.outputLocation(),
            )
    }
}
