@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cleanrooms.kotlin

import com.pulumi.aws.cleanrooms.kotlin.outputs.CollaborationDataEncryptionMetadata
import com.pulumi.aws.cleanrooms.kotlin.outputs.CollaborationMember
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.cleanrooms.kotlin.outputs.CollaborationDataEncryptionMetadata.Companion.toKotlin as collaborationDataEncryptionMetadataToKotlin
import com.pulumi.aws.cleanrooms.kotlin.outputs.CollaborationMember.Companion.toKotlin as collaborationMemberToKotlin

/**
 * Builder for [Collaboration].
 */
@PulumiTagMarker
public class CollaborationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CollaborationArgs = CollaborationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CollaborationArgsBuilder.() -> Unit) {
        val builder = CollaborationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Collaboration {
        val builtJavaResource = com.pulumi.aws.cleanrooms.Collaboration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Collaboration(builtJavaResource)
    }
}

/**
 * Provides a AWS Clean Rooms collaboration.  All members included in the definition will be invited to
 * join the collaboration and can create memberships.
 * ## Example Usage
 * ### Collaboration with tags
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testCollaboration = new aws.cleanrooms.Collaboration("test_collaboration", {
 *     name: "pulumi-example-collaboration",
 *     creatorMemberAbilities: [
 *         "CAN_QUERY",
 *         "CAN_RECEIVE_RESULTS",
 *     ],
 *     creatorDisplayName: "Creator ",
 *     description: "I made this collaboration with Pulumi!",
 *     queryLogStatus: "DISABLED",
 *     dataEncryptionMetadata: {
 *         allowClearText: true,
 *         allowDuplicates: true,
 *         allowJoinsOnColumnsWithDifferentNames: true,
 *         preserveNulls: false,
 *     },
 *     members: [{
 *         accountId: "123456789012",
 *         displayName: "Other member",
 *         memberAbilities: [],
 *     }],
 *     tags: {
 *         Project: "Pulumi",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_collaboration = aws.cleanrooms.Collaboration("test_collaboration",
 *     name="pulumi-example-collaboration",
 *     creator_member_abilities=[
 *         "CAN_QUERY",
 *         "CAN_RECEIVE_RESULTS",
 *     ],
 *     creator_display_name="Creator ",
 *     description="I made this collaboration with Pulumi!",
 *     query_log_status="DISABLED",
 *     data_encryption_metadata={
 *         "allow_clear_text": True,
 *         "allow_duplicates": True,
 *         "allow_joins_on_columns_with_different_names": True,
 *         "preserve_nulls": False,
 *     },
 *     members=[{
 *         "account_id": "123456789012",
 *         "display_name": "Other member",
 *         "member_abilities": [],
 *     }],
 *     tags={
 *         "Project": "Pulumi",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testCollaboration = new Aws.CleanRooms.Collaboration("test_collaboration", new()
 *     {
 *         Name = "pulumi-example-collaboration",
 *         CreatorMemberAbilities = new[]
 *         {
 *             "CAN_QUERY",
 *             "CAN_RECEIVE_RESULTS",
 *         },
 *         CreatorDisplayName = "Creator ",
 *         Description = "I made this collaboration with Pulumi!",
 *         QueryLogStatus = "DISABLED",
 *         DataEncryptionMetadata = new Aws.CleanRooms.Inputs.CollaborationDataEncryptionMetadataArgs
 *         {
 *             AllowClearText = true,
 *             AllowDuplicates = true,
 *             AllowJoinsOnColumnsWithDifferentNames = true,
 *             PreserveNulls = false,
 *         },
 *         Members = new[]
 *         {
 *             new Aws.CleanRooms.Inputs.CollaborationMemberArgs
 *             {
 *                 AccountId = "123456789012",
 *                 DisplayName = "Other member",
 *                 MemberAbilities = new() { },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Project", "Pulumi" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cleanrooms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cleanrooms.NewCollaboration(ctx, "test_collaboration", &cleanrooms.CollaborationArgs{
 * 			Name: pulumi.String("pulumi-example-collaboration"),
 * 			CreatorMemberAbilities: pulumi.StringArray{
 * 				pulumi.String("CAN_QUERY"),
 * 				pulumi.String("CAN_RECEIVE_RESULTS"),
 * 			},
 * 			CreatorDisplayName: pulumi.String("Creator "),
 * 			Description:        pulumi.String("I made this collaboration with Pulumi!"),
 * 			QueryLogStatus:     pulumi.String("DISABLED"),
 * 			DataEncryptionMetadata: &cleanrooms.CollaborationDataEncryptionMetadataArgs{
 * 				AllowClearText:                        pulumi.Bool(true),
 * 				AllowDuplicates:                       pulumi.Bool(true),
 * 				AllowJoinsOnColumnsWithDifferentNames: pulumi.Bool(true),
 * 				PreserveNulls:                         pulumi.Bool(false),
 * 			},
 * 			Members: cleanrooms.CollaborationMemberArray{
 * 				&cleanrooms.CollaborationMemberArgs{
 * 					AccountId:       pulumi.String("123456789012"),
 * 					DisplayName:     pulumi.String("Other member"),
 * 					MemberAbilities: pulumi.StringArray{},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Project": pulumi.String("Pulumi"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cleanrooms.Collaboration;
 * import com.pulumi.aws.cleanrooms.CollaborationArgs;
 * import com.pulumi.aws.cleanrooms.inputs.CollaborationDataEncryptionMetadataArgs;
 * import com.pulumi.aws.cleanrooms.inputs.CollaborationMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCollaboration = new Collaboration("testCollaboration", CollaborationArgs.builder()
 *             .name("pulumi-example-collaboration")
 *             .creatorMemberAbilities(
 *                 "CAN_QUERY",
 *                 "CAN_RECEIVE_RESULTS")
 *             .creatorDisplayName("Creator ")
 *             .description("I made this collaboration with Pulumi!")
 *             .queryLogStatus("DISABLED")
 *             .dataEncryptionMetadata(CollaborationDataEncryptionMetadataArgs.builder()
 *                 .allowClearText(true)
 *                 .allowDuplicates(true)
 *                 .allowJoinsOnColumnsWithDifferentNames(true)
 *                 .preserveNulls(false)
 *                 .build())
 *             .members(CollaborationMemberArgs.builder()
 *                 .accountId(123456789012)
 *                 .displayName("Other member")
 *                 .memberAbilities()
 *                 .build())
 *             .tags(Map.of("Project", "Pulumi"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testCollaboration:
 *     type: aws:cleanrooms:Collaboration
 *     name: test_collaboration
 *     properties:
 *       name: pulumi-example-collaboration
 *       creatorMemberAbilities:
 *         - CAN_QUERY
 *         - CAN_RECEIVE_RESULTS
 *       creatorDisplayName: 'Creator '
 *       description: I made this collaboration with Pulumi!
 *       queryLogStatus: DISABLED
 *       dataEncryptionMetadata:
 *         allowClearText: true
 *         allowDuplicates: true
 *         allowJoinsOnColumnsWithDifferentNames: true
 *         preserveNulls: false
 *       members:
 *         - accountId: 1.23456789012e+11
 *           displayName: Other member
 *           memberAbilities: []
 *       tags:
 *         Project: Pulumi
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_cleanrooms_collaboration` using the `id`. For example:
 * ```sh
 * $ pulumi import aws:cleanrooms/collaboration:Collaboration collaboration 1234abcd-12ab-34cd-56ef-1234567890ab
 * ```
 */
public class Collaboration internal constructor(
    override val javaResource: com.pulumi.aws.cleanrooms.Collaboration,
) : KotlinCustomResource(javaResource, CollaborationMapper) {
    /**
     * The arn of the collaboration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The date and time the collaboration was created.
     * * `member status` - For each member included in the collaboration an additional computed attribute of status is added. These values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_MemberSummary.html#API-Type-MemberSummary-status).
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The name for the member record for the collaboration creator.
     */
    public val creatorDisplayName: Output<String>
        get() = javaResource.creatorDisplayName().applyValue({ args0 -> args0 })

    /**
     * The list of member abilities for the creator of the collaboration.  Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
     */
    public val creatorMemberAbilities: Output<List<String>>
        get() = javaResource.creatorMemberAbilities().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * a collection of settings which determine how the [c3r client](https://docs.aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration.
     * * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
     * field.
     * * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
     * boolean field.
     * * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
     * n any other Fingerprint column with a different name. This is a boolean field.
     * * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
     * or cryptographically processed (false).
     */
    public val dataEncryptionMetadata: Output<CollaborationDataEncryptionMetadata>?
        get() = javaResource.dataEncryptionMetadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> collaborationDataEncryptionMetadataToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A description for a collaboration.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Additional members of the collaboration which will be invited to join the collaboration.
     * * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
     * * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
     * * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
     */
    public val members: Output<List<CollaborationMember>>?
        get() = javaResource.members().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> collaborationMemberToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the collaboration.  Collaboration names do not need to be unique.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Determines if members of the collaboration can enable query logs within their own.
     * emberships. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-queryLogStatus).
     */
    public val queryLogStatus: Output<String>
        get() = javaResource.queryLogStatus().applyValue({ args0 -> args0 })

    /**
     * Key value pairs which tag the collaboration.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val updateTime: Output<String>
        get() = javaResource.updateTime().applyValue({ args0 -> args0 })
}

public object CollaborationMapper : ResourceMapper<Collaboration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cleanrooms.Collaboration::class == javaResource::class

    override fun map(javaResource: Resource): Collaboration = Collaboration(
        javaResource as
            com.pulumi.aws.cleanrooms.Collaboration,
    )
}

/**
 * @see [Collaboration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Collaboration].
 */
public suspend fun collaboration(
    name: String,
    block: suspend CollaborationResourceBuilder.() -> Unit,
): Collaboration {
    val builder = CollaborationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Collaboration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun collaboration(name: String): Collaboration {
    val builder = CollaborationResourceBuilder()
    builder.name(name)
    return builder.build()
}
