@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cleanrooms.kotlin.inputs

import com.pulumi.aws.cleanrooms.inputs.CollaborationDataEncryptionMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property allowClearText
 * @property allowDuplicates
 * @property allowJoinsOnColumnsWithDifferentNames
 * @property preserveNulls
 */
public data class CollaborationDataEncryptionMetadataArgs(
    public val allowClearText: Output<Boolean>,
    public val allowDuplicates: Output<Boolean>,
    public val allowJoinsOnColumnsWithDifferentNames: Output<Boolean>,
    public val preserveNulls: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.cleanrooms.inputs.CollaborationDataEncryptionMetadataArgs> {
    override fun toJava(): com.pulumi.aws.cleanrooms.inputs.CollaborationDataEncryptionMetadataArgs =
        com.pulumi.aws.cleanrooms.inputs.CollaborationDataEncryptionMetadataArgs.builder()
            .allowClearText(allowClearText.applyValue({ args0 -> args0 }))
            .allowDuplicates(allowDuplicates.applyValue({ args0 -> args0 }))
            .allowJoinsOnColumnsWithDifferentNames(
                allowJoinsOnColumnsWithDifferentNames.applyValue({ args0 ->
                    args0
                }),
            )
            .preserveNulls(preserveNulls.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CollaborationDataEncryptionMetadataArgs].
 */
@PulumiTagMarker
public class CollaborationDataEncryptionMetadataArgsBuilder internal constructor() {
    private var allowClearText: Output<Boolean>? = null

    private var allowDuplicates: Output<Boolean>? = null

    private var allowJoinsOnColumnsWithDifferentNames: Output<Boolean>? = null

    private var preserveNulls: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("trhawtxomvfugacc")
    public suspend fun allowClearText(`value`: Output<Boolean>) {
        this.allowClearText = value
    }

    /**
     * @param value
     */
    @JvmName("frenytbacpueixxi")
    public suspend fun allowDuplicates(`value`: Output<Boolean>) {
        this.allowDuplicates = value
    }

    /**
     * @param value
     */
    @JvmName("kferqddlyenhaojj")
    public suspend fun allowJoinsOnColumnsWithDifferentNames(`value`: Output<Boolean>) {
        this.allowJoinsOnColumnsWithDifferentNames = value
    }

    /**
     * @param value
     */
    @JvmName("ipogxekmrpjcvhgn")
    public suspend fun preserveNulls(`value`: Output<Boolean>) {
        this.preserveNulls = value
    }

    /**
     * @param value
     */
    @JvmName("mvmuexwfwhaelcnm")
    public suspend fun allowClearText(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowClearText = mapped
    }

    /**
     * @param value
     */
    @JvmName("tfwajnwwfiuaynmw")
    public suspend fun allowDuplicates(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowDuplicates = mapped
    }

    /**
     * @param value
     */
    @JvmName("gbkbvrfypflvwpwq")
    public suspend fun allowJoinsOnColumnsWithDifferentNames(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowJoinsOnColumnsWithDifferentNames = mapped
    }

    /**
     * @param value
     */
    @JvmName("aohpfajjsustwqbc")
    public suspend fun preserveNulls(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preserveNulls = mapped
    }

    internal fun build(): CollaborationDataEncryptionMetadataArgs =
        CollaborationDataEncryptionMetadataArgs(
            allowClearText = allowClearText ?: throw PulumiNullFieldException("allowClearText"),
            allowDuplicates = allowDuplicates ?: throw PulumiNullFieldException("allowDuplicates"),
            allowJoinsOnColumnsWithDifferentNames = allowJoinsOnColumnsWithDifferentNames ?: throw
                PulumiNullFieldException("allowJoinsOnColumnsWithDifferentNames"),
            preserveNulls = preserveNulls ?: throw PulumiNullFieldException("preserveNulls"),
        )
}
