@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cleanrooms.kotlin.inputs

import com.pulumi.aws.cleanrooms.inputs.CollaborationMemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property accountId
 * @property displayName
 * @property memberAbilities
 * @property status
 */
public data class CollaborationMemberArgs(
    public val accountId: Output<String>,
    public val displayName: Output<String>,
    public val memberAbilities: Output<List<String>>,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cleanrooms.inputs.CollaborationMemberArgs> {
    override fun toJava(): com.pulumi.aws.cleanrooms.inputs.CollaborationMemberArgs =
        com.pulumi.aws.cleanrooms.inputs.CollaborationMemberArgs.builder()
            .accountId(accountId.applyValue({ args0 -> args0 }))
            .displayName(displayName.applyValue({ args0 -> args0 }))
            .memberAbilities(memberAbilities.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CollaborationMemberArgs].
 */
@PulumiTagMarker
public class CollaborationMemberArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var displayName: Output<String>? = null

    private var memberAbilities: Output<List<String>>? = null

    private var status: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("roavpnrnpklifhjn")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value
     */
    @JvmName("lrtbjqstckewcarj")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value
     */
    @JvmName("adjbxlejaockyyqh")
    public suspend fun memberAbilities(`value`: Output<List<String>>) {
        this.memberAbilities = value
    }

    @JvmName("piyjposisocyffpe")
    public suspend fun memberAbilities(vararg values: Output<String>) {
        this.memberAbilities = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("bsmcayixggymfuom")
    public suspend fun memberAbilities(values: List<Output<String>>) {
        this.memberAbilities = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("xvkqhohrfbnyuqrj")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value
     */
    @JvmName("obifsgbxscijiniu")
    public suspend fun accountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value
     */
    @JvmName("arwgcdqkcijkvkfs")
    public suspend fun displayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value
     */
    @JvmName("mttqyexhbwmmygxx")
    public suspend fun memberAbilities(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memberAbilities = mapped
    }

    /**
     * @param values
     */
    @JvmName("mpfwbdveefrjkcbn")
    public suspend fun memberAbilities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memberAbilities = mapped
    }

    /**
     * @param value
     */
    @JvmName("pxptutoogttbhyhk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): CollaborationMemberArgs = CollaborationMemberArgs(
        accountId = accountId ?: throw PulumiNullFieldException("accountId"),
        displayName = displayName ?: throw PulumiNullFieldException("displayName"),
        memberAbilities = memberAbilities ?: throw PulumiNullFieldException("memberAbilities"),
        status = status,
    )
}
