@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloud9.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EnvironmentEC2].
 */
@PulumiTagMarker
public class EnvironmentEC2ResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentEC2Args = EnvironmentEC2Args()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentEC2ArgsBuilder.() -> Unit) {
        val builder = EnvironmentEC2ArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EnvironmentEC2 {
        val builtJavaResource = com.pulumi.aws.cloud9.EnvironmentEC2(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EnvironmentEC2(builtJavaResource)
    }
}

/**
 * Provides a Cloud9 EC2 Development Environment.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloud9.EnvironmentEC2("example", {
 *     instanceType: "t2.micro",
 *     name: "example-env",
 *     imageId: "amazonlinux-2023-x86_64",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloud9.EnvironmentEC2("example",
 *     instance_type="t2.micro",
 *     name="example-env",
 *     image_id="amazonlinux-2023-x86_64")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cloud9.EnvironmentEC2("example", new()
 *     {
 *         InstanceType = "t2.micro",
 *         Name = "example-env",
 *         ImageId = "amazonlinux-2023-x86_64",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloud9"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloud9.NewEnvironmentEC2(ctx, "example", &cloud9.EnvironmentEC2Args{
 * 			InstanceType: pulumi.String("t2.micro"),
 * 			Name:         pulumi.String("example-env"),
 * 			ImageId:      pulumi.String("amazonlinux-2023-x86_64"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloud9.EnvironmentEC2;
 * import com.pulumi.aws.cloud9.EnvironmentEC2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EnvironmentEC2("example", EnvironmentEC2Args.builder()
 *             .instanceType("t2.micro")
 *             .name("example-env")
 *             .imageId("amazonlinux-2023-x86_64")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloud9:EnvironmentEC2
 *     properties:
 *       instanceType: t2.micro
 *       name: example-env
 *       imageId: amazonlinux-2023-x86_64
 * ```
 * <!--End PulumiCodeChooser -->
 * Get the URL of the Cloud9 environment after creation:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloud9.EnvironmentEC2("example", {instanceType: "t2.micro"});
 * const cloud9Instance = aws.ec2.getInstanceOutput({
 *     filters: [{
 *         name: "tag:aws:cloud9:environment",
 *         values: [example&#46;id],
 *     }],
 * });
 * export const cloud9Url = pulumi.interpolate`https://${region}.console.aws.amazon.com/cloud9/ide/${example.id}`;
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloud9.EnvironmentEC2("example", instance_type="t2.micro")
 * cloud9_instance = aws.ec2.get_instance_output(filters=[{
 *     "name": "tag:aws:cloud9:environment",
 *     "values": [example&#46;id],
 * }])
 * pulumi.export("cloud9Url", example.id.apply(lambda id: f"https://{region}.console.aws.amazon.com/cloud9/ide/{id}"))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cloud9.EnvironmentEC2("example", new()
 *     {
 *         InstanceType = "t2.micro",
 *     });
 *     var cloud9Instance = Aws.Ec2.GetInstance.Invoke(new()
 *     {
 *         Filters = new[]
 *         {
 *             new Aws.Ec2.Inputs.GetInstanceFilterInputArgs
 *             {
 *                 Name = "tag:aws:cloud9:environment",
 *                 Values = new[]
 *                 {
 *                     example.Id,
 *                 },
 *             },
 *         },
 *     });
 *     return new Dictionary<string, object?>
 *     {
 *         ["cloud9Url"] = example.Id.Apply(id => $"https://{region}.console.aws.amazon.com/cloud9/ide/{id}"),
 *     };
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloud9"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cloud9.NewEnvironmentEC2(ctx, "example", &cloud9.EnvironmentEC2Args{
 * 			InstanceType: pulumi.String("t2.micro"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_ = ec2.LookupInstanceOutput(ctx, ec2.GetInstanceOutputArgs{
 * 			Filters: ec2.GetInstanceFilterArray{
 * 				&ec2.GetInstanceFilterArgs{
 * 					Name: pulumi.String("tag:aws:cloud9:environment"),
 * 					Values: pulumi.StringArray{
 * 						example.ID(),
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		ctx.Export("cloud9Url", example.ID().ApplyT(func(id string) (string, error) {
 * 			return fmt.Sprintf("https://%v.console.aws.amazon.com/cloud9/ide/%v", region, id), nil
 * 		}).(pulumi.StringOutput))
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloud9.EnvironmentEC2;
 * import com.pulumi.aws.cloud9.EnvironmentEC2Args;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EnvironmentEC2("example", EnvironmentEC2Args.builder()
 *             .instanceType("t2.micro")
 *             .build());
 *         final var cloud9Instance = Ec2Functions.getInstance(GetInstanceArgs.builder()
 *             .filters(GetInstanceFilterArgs.builder()
 *                 .name("tag:aws:cloud9:environment")
 *                 .values(example.id())
 *                 .build())
 *             .build());
 *         ctx.export("cloud9Url", example.id().applyValue(id -> String.format("https://%s.console.aws.amazon.com/cloud9/ide/%s", region,id)));
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloud9:EnvironmentEC2
 *     properties:
 *       instanceType: t2.micro
 * variables:
 *   cloud9Instance:
 *     fn::invoke:
 *       Function: aws:ec2:getInstance
 *       Arguments:
 *         filters:
 *           - name: tag:aws:cloud9:environment
 *             values:
 *               - ${example.id}
 * outputs:
 *   cloud9Url: https://${region}.console.aws.amazon.com/cloud9/ide/${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * Allocate a static IP to the Cloud9 environment:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloud9.EnvironmentEC2("example", {instanceType: "t2.micro"});
 * const cloud9Instance = aws.ec2.getInstanceOutput({
 *     filters: [{
 *         name: "tag:aws:cloud9:environment",
 *         values: [example&#46;id],
 *     }],
 * });
 * const cloud9Eip = new aws.ec2.Eip("cloud9_eip", {
 *     instance: cloud9Instance.apply(cloud9Instance => cloud9Instance.id),
 *     domain: "vpc",
 * });
 * export const cloud9PublicIp = cloud9Eip.publicIp;
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloud9.EnvironmentEC2("example", instance_type="t2.micro")
 * cloud9_instance = aws.ec2.get_instance_output(filters=[{
 *     "name": "tag:aws:cloud9:environment",
 *     "values": [example&#46;id],
 * }])
 * cloud9_eip = aws.ec2.Eip("cloud9_eip",
 *     instance=cloud9_instance.id,
 *     domain="vpc")
 * pulumi.export("cloud9PublicIp", cloud9_eip.public_ip)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cloud9.EnvironmentEC2("example", new()
 *     {
 *         InstanceType = "t2.micro",
 *     });
 *     var cloud9Instance = Aws.Ec2.GetInstance.Invoke(new()
 *     {
 *         Filters = new[]
 *         {
 *             new Aws.Ec2.Inputs.GetInstanceFilterInputArgs
 *             {
 *                 Name = "tag:aws:cloud9:environment",
 *                 Values = new[]
 *                 {
 *                     example.Id,
 *                 },
 *             },
 *         },
 *     });
 *     var cloud9Eip = new Aws.Ec2.Eip("cloud9_eip", new()
 *     {
 *         Instance = cloud9Instance.Apply(getInstanceResult => getInstanceResult.Id),
 *         Domain = "vpc",
 *     });
 *     return new Dictionary<string, object?>
 *     {
 *         ["cloud9PublicIp"] = cloud9Eip.PublicIp,
 *     };
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloud9"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cloud9.NewEnvironmentEC2(ctx, "example", &cloud9.EnvironmentEC2Args{
 * 			InstanceType: pulumi.String("t2.micro"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cloud9Instance := ec2.LookupInstanceOutput(ctx, ec2.GetInstanceOutputArgs{
 * 			Filters: ec2.GetInstanceFilterArray{
 * 				&ec2.GetInstanceFilterArgs{
 * 					Name: pulumi.String("tag:aws:cloud9:environment"),
 * 					Values: pulumi.StringArray{
 * 						example.ID(),
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		cloud9Eip, err := ec2.NewEip(ctx, "cloud9_eip", &ec2.EipArgs{
 * 			Instance: pulumi.String(cloud9Instance.ApplyT(func(cloud9Instance ec2.GetInstanceResult) (*string, error) {
 * 				return &cloud9Instance.Id, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 			Domain: pulumi.String("vpc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		ctx.Export("cloud9PublicIp", cloud9Eip.PublicIp)
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloud9.EnvironmentEC2;
 * import com.pulumi.aws.cloud9.EnvironmentEC2Args;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetInstanceArgs;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EnvironmentEC2("example", EnvironmentEC2Args.builder()
 *             .instanceType("t2.micro")
 *             .build());
 *         final var cloud9Instance = Ec2Functions.getInstance(GetInstanceArgs.builder()
 *             .filters(GetInstanceFilterArgs.builder()
 *                 .name("tag:aws:cloud9:environment")
 *                 .values(example.id())
 *                 .build())
 *             .build());
 *         var cloud9Eip = new Eip("cloud9Eip", EipArgs.builder()
 *             .instance(cloud9Instance.applyValue(getInstanceResult -> getInstanceResult).applyValue(cloud9Instance -> cloud9Instance.applyValue(getInstanceResult -> getInstanceResult.id())))
 *             .domain("vpc")
 *             .build());
 *         ctx.export("cloud9PublicIp", cloud9Eip.publicIp());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloud9:EnvironmentEC2
 *     properties:
 *       instanceType: t2.micro
 *   cloud9Eip:
 *     type: aws:ec2:Eip
 *     name: cloud9_eip
 *     properties:
 *       instance: ${cloud9Instance.id}
 *       domain: vpc
 * variables:
 *   cloud9Instance:
 *     fn::invoke:
 *       Function: aws:ec2:getInstance
 *       Arguments:
 *         filters:
 *           - name: tag:aws:cloud9:environment
 *             values:
 *               - ${example.id}
 * outputs:
 *   cloud9PublicIp: ${cloud9Eip.publicIp}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class EnvironmentEC2 internal constructor(
    override val javaResource: com.pulumi.aws.cloud9.EnvironmentEC2,
) : KotlinCustomResource(javaResource, EnvironmentEC2Mapper) {
    /**
     * The ARN of the environment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The number of minutes until the running instance is shut down after the environment has last been used.
     */
    public val automaticStopTimeMinutes: Output<Int>?
        get() = javaResource.automaticStopTimeMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The connection type used for connecting to an Amazon EC2 environment. Valid values are `CONNECT_SSH` and `CONNECT_SSM`. For more information please refer [AWS documentation for Cloud9](https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html).
     */
    public val connectionType: Output<String>?
        get() = javaResource.connectionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the environment.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance. Valid values are
     * * `amazonlinux-2-x86_64`
     * * `amazonlinux-2023-x86_64`
     * * `ubuntu-18.04-x86_64`
     * * `ubuntu-22.04-x86_64`
     * * `resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64`
     * * `resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2023-x86_64`
     * * `resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64`
     * * `resolve:ssm:/aws/service/cloud9/amis/ubuntu-22.04-x86_64`
     */
    public val imageId: Output<String>
        get() = javaResource.imageId().applyValue({ args0 -> args0 })

    /**
     * The type of instance to connect to the environment, e.g., `t2.micro`.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * The name of the environment.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARN of the environment owner. This can be ARN of any AWS IAM principal. Defaults to the environment's creator.
     */
    public val ownerArn: Output<String>
        get() = javaResource.ownerArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the subnet in Amazon VPC that AWS Cloud9 will use to communicate with the Amazon EC2 instance.
     */
    public val subnetId: Output<String>?
        get() = javaResource.subnetId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of the environment (e.g., `ssh` or `ec2`).
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EnvironmentEC2Mapper : ResourceMapper<EnvironmentEC2> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloud9.EnvironmentEC2::class == javaResource::class

    override fun map(javaResource: Resource): EnvironmentEC2 = EnvironmentEC2(
        javaResource as
            com.pulumi.aws.cloud9.EnvironmentEC2,
    )
}

/**
 * @see [EnvironmentEC2].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnvironmentEC2].
 */
public suspend fun environmentEC2(
    name: String,
    block: suspend EnvironmentEC2ResourceBuilder.() -> Unit,
): EnvironmentEC2 {
    val builder = EnvironmentEC2ResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnvironmentEC2].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environmentEC2(name: String): EnvironmentEC2 {
    val builder = EnvironmentEC2ResourceBuilder()
    builder.name(name)
    return builder.build()
}
