@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloud9.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EnvironmentMembership].
 */
@PulumiTagMarker
public class EnvironmentMembershipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentMembershipArgs = EnvironmentMembershipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentMembershipArgsBuilder.() -> Unit) {
        val builder = EnvironmentMembershipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EnvironmentMembership {
        val builtJavaResource = com.pulumi.aws.cloud9.EnvironmentMembership(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EnvironmentMembership(builtJavaResource)
    }
}

/**
 * Provides an environment member to an AWS Cloud9 development environment.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.cloud9.EnvironmentEC2("test", {
 *     instanceType: "t2.micro",
 *     name: "some-env",
 * });
 * const testUser = new aws.iam.User("test", {name: "some-user"});
 * const testEnvironmentMembership = new aws.cloud9.EnvironmentMembership("test", {
 *     environmentId: test.id,
 *     permissions: "read-only",
 *     userArn: testUser.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.cloud9.EnvironmentEC2("test",
 *     instance_type="t2.micro",
 *     name="some-env")
 * test_user = aws.iam.User("test", name="some-user")
 * test_environment_membership = aws.cloud9.EnvironmentMembership("test",
 *     environment_id=test.id,
 *     permissions="read-only",
 *     user_arn=test_user.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Cloud9.EnvironmentEC2("test", new()
 *     {
 *         InstanceType = "t2.micro",
 *         Name = "some-env",
 *     });
 *     var testUser = new Aws.Iam.User("test", new()
 *     {
 *         Name = "some-user",
 *     });
 *     var testEnvironmentMembership = new Aws.Cloud9.EnvironmentMembership("test", new()
 *     {
 *         EnvironmentId = test.Id,
 *         Permissions = "read-only",
 *         UserArn = testUser.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloud9"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := cloud9.NewEnvironmentEC2(ctx, "test", &cloud9.EnvironmentEC2Args{
 * 			InstanceType: pulumi.String("t2.micro"),
 * 			Name:         pulumi.String("some-env"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testUser, err := iam.NewUser(ctx, "test", &iam.UserArgs{
 * 			Name: pulumi.String("some-user"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloud9.NewEnvironmentMembership(ctx, "test", &cloud9.EnvironmentMembershipArgs{
 * 			EnvironmentId: test.ID(),
 * 			Permissions:   pulumi.String("read-only"),
 * 			UserArn:       testUser.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloud9.EnvironmentEC2;
 * import com.pulumi.aws.cloud9.EnvironmentEC2Args;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.cloud9.EnvironmentMembership;
 * import com.pulumi.aws.cloud9.EnvironmentMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EnvironmentEC2("test", EnvironmentEC2Args.builder()
 *             .instanceType("t2.micro")
 *             .name("some-env")
 *             .build());
 *         var testUser = new User("testUser", UserArgs.builder()
 *             .name("some-user")
 *             .build());
 *         var testEnvironmentMembership = new EnvironmentMembership("testEnvironmentMembership", EnvironmentMembershipArgs.builder()
 *             .environmentId(test.id())
 *             .permissions("read-only")
 *             .userArn(testUser.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:cloud9:EnvironmentEC2
 *     properties:
 *       instanceType: t2.micro
 *       name: some-env
 *   testUser:
 *     type: aws:iam:User
 *     name: test
 *     properties:
 *       name: some-user
 *   testEnvironmentMembership:
 *     type: aws:cloud9:EnvironmentMembership
 *     name: test
 *     properties:
 *       environmentId: ${test.id}
 *       permissions: read-only
 *       userArn: ${testUser.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cloud9 environment membership using the `environment-id#user-arn`. For example:
 * ```sh
 * $ pulumi import aws:cloud9/environmentMembership:EnvironmentMembership test environment-id#user-arn
 * ```
 */
public class EnvironmentMembership internal constructor(
    override val javaResource: com.pulumi.aws.cloud9.EnvironmentMembership,
) : KotlinCustomResource(javaResource, EnvironmentMembershipMapper) {
    /**
     * The ID of the environment that contains the environment member you want to add.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * The type of environment member permissions you want to associate with this environment member. Allowed values are `read-only` and `read-write` .
     */
    public val permissions: Output<String>
        get() = javaResource.permissions().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the environment member you want to add.
     */
    public val userArn: Output<String>
        get() = javaResource.userArn().applyValue({ args0 -> args0 })

    /**
     * The user ID in AWS Identity and Access Management (AWS IAM) of the environment member.
     */
    public val userId: Output<String>
        get() = javaResource.userId().applyValue({ args0 -> args0 })
}

public object EnvironmentMembershipMapper : ResourceMapper<EnvironmentMembership> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloud9.EnvironmentMembership::class == javaResource::class

    override fun map(javaResource: Resource): EnvironmentMembership =
        EnvironmentMembership(javaResource as com.pulumi.aws.cloud9.EnvironmentMembership)
}

/**
 * @see [EnvironmentMembership].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnvironmentMembership].
 */
public suspend fun environmentMembership(
    name: String,
    block: suspend EnvironmentMembershipResourceBuilder.() -> Unit,
): EnvironmentMembership {
    val builder = EnvironmentMembershipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnvironmentMembership].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environmentMembership(name: String): EnvironmentMembership {
    val builder = EnvironmentMembershipResourceBuilder()
    builder.name(name)
    return builder.build()
}
