@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloud9.kotlin

import com.pulumi.aws.cloud9.EnvironmentMembershipArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an environment member to an AWS Cloud9 development environment.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.cloud9.EnvironmentEC2("test", {
 *     instanceType: "t2.micro",
 *     name: "some-env",
 * });
 * const testUser = new aws.iam.User("test", {name: "some-user"});
 * const testEnvironmentMembership = new aws.cloud9.EnvironmentMembership("test", {
 *     environmentId: test.id,
 *     permissions: "read-only",
 *     userArn: testUser.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.cloud9.EnvironmentEC2("test",
 *     instance_type="t2.micro",
 *     name="some-env")
 * test_user = aws.iam.User("test", name="some-user")
 * test_environment_membership = aws.cloud9.EnvironmentMembership("test",
 *     environment_id=test.id,
 *     permissions="read-only",
 *     user_arn=test_user.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Cloud9.EnvironmentEC2("test", new()
 *     {
 *         InstanceType = "t2.micro",
 *         Name = "some-env",
 *     });
 *     var testUser = new Aws.Iam.User("test", new()
 *     {
 *         Name = "some-user",
 *     });
 *     var testEnvironmentMembership = new Aws.Cloud9.EnvironmentMembership("test", new()
 *     {
 *         EnvironmentId = test.Id,
 *         Permissions = "read-only",
 *         UserArn = testUser.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloud9"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := cloud9.NewEnvironmentEC2(ctx, "test", &cloud9.EnvironmentEC2Args{
 * 			InstanceType: pulumi.String("t2.micro"),
 * 			Name:         pulumi.String("some-env"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testUser, err := iam.NewUser(ctx, "test", &iam.UserArgs{
 * 			Name: pulumi.String("some-user"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloud9.NewEnvironmentMembership(ctx, "test", &cloud9.EnvironmentMembershipArgs{
 * 			EnvironmentId: test.ID(),
 * 			Permissions:   pulumi.String("read-only"),
 * 			UserArn:       testUser.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloud9.EnvironmentEC2;
 * import com.pulumi.aws.cloud9.EnvironmentEC2Args;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.cloud9.EnvironmentMembership;
 * import com.pulumi.aws.cloud9.EnvironmentMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EnvironmentEC2("test", EnvironmentEC2Args.builder()
 *             .instanceType("t2.micro")
 *             .name("some-env")
 *             .build());
 *         var testUser = new User("testUser", UserArgs.builder()
 *             .name("some-user")
 *             .build());
 *         var testEnvironmentMembership = new EnvironmentMembership("testEnvironmentMembership", EnvironmentMembershipArgs.builder()
 *             .environmentId(test.id())
 *             .permissions("read-only")
 *             .userArn(testUser.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:cloud9:EnvironmentEC2
 *     properties:
 *       instanceType: t2.micro
 *       name: some-env
 *   testUser:
 *     type: aws:iam:User
 *     name: test
 *     properties:
 *       name: some-user
 *   testEnvironmentMembership:
 *     type: aws:cloud9:EnvironmentMembership
 *     name: test
 *     properties:
 *       environmentId: ${test.id}
 *       permissions: read-only
 *       userArn: ${testUser.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cloud9 environment membership using the `environment-id#user-arn`. For example:
 * ```sh
 * $ pulumi import aws:cloud9/environmentMembership:EnvironmentMembership test environment-id#user-arn
 * ```
 * @property environmentId The ID of the environment that contains the environment member you want to add.
 * @property permissions The type of environment member permissions you want to associate with this environment member. Allowed values are `read-only` and `read-write` .
 * @property userArn The Amazon Resource Name (ARN) of the environment member you want to add.
 */
public data class EnvironmentMembershipArgs(
    public val environmentId: Output<String>? = null,
    public val permissions: Output<String>? = null,
    public val userArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloud9.EnvironmentMembershipArgs> {
    override fun toJava(): com.pulumi.aws.cloud9.EnvironmentMembershipArgs =
        com.pulumi.aws.cloud9.EnvironmentMembershipArgs.builder()
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .permissions(permissions?.applyValue({ args0 -> args0 }))
            .userArn(userArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentMembershipArgs].
 */
@PulumiTagMarker
public class EnvironmentMembershipArgsBuilder internal constructor() {
    private var environmentId: Output<String>? = null

    private var permissions: Output<String>? = null

    private var userArn: Output<String>? = null

    /**
     * @param value The ID of the environment that contains the environment member you want to add.
     */
    @JvmName("glbaksoocwhyxylr")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value The type of environment member permissions you want to associate with this environment member. Allowed values are `read-only` and `read-write` .
     */
    @JvmName("omdflkbaeomiwkwu")
    public suspend fun permissions(`value`: Output<String>) {
        this.permissions = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the environment member you want to add.
     */
    @JvmName("sycdaabdpsrnwfcj")
    public suspend fun userArn(`value`: Output<String>) {
        this.userArn = value
    }

    /**
     * @param value The ID of the environment that contains the environment member you want to add.
     */
    @JvmName("mxyfjbmdoiseamkc")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value The type of environment member permissions you want to associate with this environment member. Allowed values are `read-only` and `read-write` .
     */
    @JvmName("wktinrxttgejtdow")
    public suspend fun permissions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the environment member you want to add.
     */
    @JvmName("ewymsuppllasamct")
    public suspend fun userArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userArn = mapped
    }

    internal fun build(): EnvironmentMembershipArgs = EnvironmentMembershipArgs(
        environmentId = environmentId,
        permissions = permissions,
        userArn = userArn,
    )
}
