@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudcontrol.kotlin.inputs

import com.pulumi.aws.cloudcontrol.inputs.GetResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResource.
 * @property identifier Identifier of the CloudFormation resource type. For example, `vpc-12345678`.
 * @property roleArn ARN of the IAM Role to assume for operations.
 * @property typeName CloudFormation resource type name. For example, `AWS::EC2::VPC`.
 * The following arguments are optional:
 * @property typeVersionId Identifier of the CloudFormation resource type version.
 */
public data class GetResourcePlainArgs(
    public val identifier: String,
    public val roleArn: String? = null,
    public val typeName: String,
    public val typeVersionId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudcontrol.inputs.GetResourcePlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudcontrol.inputs.GetResourcePlainArgs =
        com.pulumi.aws.cloudcontrol.inputs.GetResourcePlainArgs.builder()
            .identifier(identifier.let({ args0 -> args0 }))
            .roleArn(roleArn?.let({ args0 -> args0 }))
            .typeName(typeName.let({ args0 -> args0 }))
            .typeVersionId(typeVersionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourcePlainArgs].
 */
@PulumiTagMarker
public class GetResourcePlainArgsBuilder internal constructor() {
    private var identifier: String? = null

    private var roleArn: String? = null

    private var typeName: String? = null

    private var typeVersionId: String? = null

    /**
     * @param value Identifier of the CloudFormation resource type. For example, `vpc-12345678`.
     */
    @JvmName("vsvhpfqigioelrcn")
    public suspend fun identifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.identifier = mapped
    }

    /**
     * @param value ARN of the IAM Role to assume for operations.
     */
    @JvmName("xuyqptrsngomoxcv")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.roleArn = mapped
    }

    /**
     * @param value CloudFormation resource type name. For example, `AWS::EC2::VPC`.
     * The following arguments are optional:
     */
    @JvmName("gnhmhbwttqmxkxse")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.typeName = mapped
    }

    /**
     * @param value Identifier of the CloudFormation resource type version.
     */
    @JvmName("glcayogltdqnjgoh")
    public suspend fun typeVersionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.typeVersionId = mapped
    }

    internal fun build(): GetResourcePlainArgs = GetResourcePlainArgs(
        identifier = identifier ?: throw PulumiNullFieldException("identifier"),
        roleArn = roleArn,
        typeName = typeName ?: throw PulumiNullFieldException("typeName"),
        typeVersionId = typeVersionId,
    )
}
