@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin

import com.pulumi.aws.cloudformation.CloudFormationTypeArgs.builder
import com.pulumi.aws.cloudformation.kotlin.inputs.CloudFormationTypeLoggingConfigArgs
import com.pulumi.aws.cloudformation.kotlin.inputs.CloudFormationTypeLoggingConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages a version of a CloudFormation Type.
 * ## Import
 * Using `pulumi import`, import `aws_cloudformation_type` using the type version Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:cloudformation/cloudFormationType:CloudFormationType example arn:aws:cloudformation:us-east-1:123456789012:type/resource/ExampleCompany-ExampleService-ExampleType/1
 * ```
 * @property executionRoleArn Amazon Resource Name (ARN) of the IAM Role for CloudFormation to assume when invoking the extension. If your extension calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. When CloudFormation needs to invoke the extension handler, CloudFormation assumes this execution role to create a temporary session token, which it then passes to the extension handler, thereby supplying your extension with the appropriate credentials.
 * @property loggingConfig Configuration block containing logging configuration.
 * @property schemaHandlerPackage URL to the S3 bucket containing the extension project package that contains the necessary files for the extension you want to register. Must begin with `s3://` or `https://`. For example, `s3://example-bucket/example-object`.
 * @property type CloudFormation Registry Type. For example, `RESOURCE` or `MODULE`.
 * @property typeName CloudFormation Type name. For example, `ExampleCompany::ExampleService::ExampleResource`.
 */
public data class CloudFormationTypeArgs(
    public val executionRoleArn: Output<String>? = null,
    public val loggingConfig: Output<CloudFormationTypeLoggingConfigArgs>? = null,
    public val schemaHandlerPackage: Output<String>? = null,
    public val type: Output<String>? = null,
    public val typeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudformation.CloudFormationTypeArgs> {
    override fun toJava(): com.pulumi.aws.cloudformation.CloudFormationTypeArgs =
        com.pulumi.aws.cloudformation.CloudFormationTypeArgs.builder()
            .executionRoleArn(executionRoleArn?.applyValue({ args0 -> args0 }))
            .loggingConfig(loggingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .schemaHandlerPackage(schemaHandlerPackage?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .typeName(typeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CloudFormationTypeArgs].
 */
@PulumiTagMarker
public class CloudFormationTypeArgsBuilder internal constructor() {
    private var executionRoleArn: Output<String>? = null

    private var loggingConfig: Output<CloudFormationTypeLoggingConfigArgs>? = null

    private var schemaHandlerPackage: Output<String>? = null

    private var type: Output<String>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role for CloudFormation to assume when invoking the extension. If your extension calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. When CloudFormation needs to invoke the extension handler, CloudFormation assumes this execution role to create a temporary session token, which it then passes to the extension handler, thereby supplying your extension with the appropriate credentials.
     */
    @JvmName("ioavdewdvabwtfgx")
    public suspend fun executionRoleArn(`value`: Output<String>) {
        this.executionRoleArn = value
    }

    /**
     * @param value Configuration block containing logging configuration.
     */
    @JvmName("byyypcrwnqdyxvyk")
    public suspend fun loggingConfig(`value`: Output<CloudFormationTypeLoggingConfigArgs>) {
        this.loggingConfig = value
    }

    /**
     * @param value URL to the S3 bucket containing the extension project package that contains the necessary files for the extension you want to register. Must begin with `s3://` or `https://`. For example, `s3://example-bucket/example-object`.
     */
    @JvmName("kkxllwrcqfecmyxm")
    public suspend fun schemaHandlerPackage(`value`: Output<String>) {
        this.schemaHandlerPackage = value
    }

    /**
     * @param value CloudFormation Registry Type. For example, `RESOURCE` or `MODULE`.
     */
    @JvmName("joicsytoxgvtdowh")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value CloudFormation Type name. For example, `ExampleCompany::ExampleService::ExampleResource`.
     */
    @JvmName("ulkrwptxkrxjwplf")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role for CloudFormation to assume when invoking the extension. If your extension calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. When CloudFormation needs to invoke the extension handler, CloudFormation assumes this execution role to create a temporary session token, which it then passes to the extension handler, thereby supplying your extension with the appropriate credentials.
     */
    @JvmName("ohwcehhxdjilffvo")
    public suspend fun executionRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionRoleArn = mapped
    }

    /**
     * @param value Configuration block containing logging configuration.
     */
    @JvmName("owxxviepgukrwbfg")
    public suspend fun loggingConfig(`value`: CloudFormationTypeLoggingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingConfig = mapped
    }

    /**
     * @param argument Configuration block containing logging configuration.
     */
    @JvmName("jlekwfjxiwnvkctq")
    public suspend fun loggingConfig(argument: suspend CloudFormationTypeLoggingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = CloudFormationTypeLoggingConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loggingConfig = mapped
    }

    /**
     * @param value URL to the S3 bucket containing the extension project package that contains the necessary files for the extension you want to register. Must begin with `s3://` or `https://`. For example, `s3://example-bucket/example-object`.
     */
    @JvmName("lhataujocfgkndrl")
    public suspend fun schemaHandlerPackage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaHandlerPackage = mapped
    }

    /**
     * @param value CloudFormation Registry Type. For example, `RESOURCE` or `MODULE`.
     */
    @JvmName("tdwdpiwgrquwtvbd")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value CloudFormation Type name. For example, `ExampleCompany::ExampleService::ExampleResource`.
     */
    @JvmName("oirlcckjufjnkivi")
    public suspend fun typeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): CloudFormationTypeArgs = CloudFormationTypeArgs(
        executionRoleArn = executionRoleArn,
        loggingConfig = loggingConfig,
        schemaHandlerPackage = schemaHandlerPackage,
        type = type,
        typeName = typeName,
    )
}
