@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin

import com.pulumi.aws.cloudformation.CloudformationFunctions.getCloudFormationTypePlain
import com.pulumi.aws.cloudformation.CloudformationFunctions.getExportPlain
import com.pulumi.aws.cloudformation.CloudformationFunctions.getStackPlain
import com.pulumi.aws.cloudformation.kotlin.inputs.GetCloudFormationTypePlainArgs
import com.pulumi.aws.cloudformation.kotlin.inputs.GetCloudFormationTypePlainArgsBuilder
import com.pulumi.aws.cloudformation.kotlin.inputs.GetExportPlainArgs
import com.pulumi.aws.cloudformation.kotlin.inputs.GetExportPlainArgsBuilder
import com.pulumi.aws.cloudformation.kotlin.inputs.GetStackPlainArgs
import com.pulumi.aws.cloudformation.kotlin.inputs.GetStackPlainArgsBuilder
import com.pulumi.aws.cloudformation.kotlin.outputs.GetCloudFormationTypeResult
import com.pulumi.aws.cloudformation.kotlin.outputs.GetExportResult
import com.pulumi.aws.cloudformation.kotlin.outputs.GetStackResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.cloudformation.kotlin.outputs.GetCloudFormationTypeResult.Companion.toKotlin as getCloudFormationTypeResultToKotlin
import com.pulumi.aws.cloudformation.kotlin.outputs.GetExportResult.Companion.toKotlin as getExportResultToKotlin
import com.pulumi.aws.cloudformation.kotlin.outputs.GetStackResult.Companion.toKotlin as getStackResultToKotlin

public object CloudformationFunctions {
    /**
     * Provides details about a CloudFormation Type.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cloudformation.getCloudFormationType({
     *     type: "RESOURCE",
     *     typeName: "AWS::Athena::WorkGroup",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cloudformation.get_cloud_formation_type(type="RESOURCE",
     *     type_name="AWS::Athena::WorkGroup")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CloudFormation.GetCloudFormationType.Invoke(new()
     *     {
     *         Type = "RESOURCE",
     *         TypeName = "AWS::Athena::WorkGroup",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudformation"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudformation.LookupCloudFormationType(ctx, &cloudformation.LookupCloudFormationTypeArgs{
     * 			Type:     pulumi.StringRef("RESOURCE"),
     * 			TypeName: pulumi.StringRef("AWS::Athena::WorkGroup"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudformation.CloudformationFunctions;
     * import com.pulumi.aws.cloudformation.inputs.GetCloudFormationTypeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudformationFunctions.getCloudFormationType(GetCloudFormationTypeArgs.builder()
     *             .type("RESOURCE")
     *             .typeName("AWS::Athena::WorkGroup")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cloudformation:getCloudFormationType
     *       Arguments:
     *         type: RESOURCE
     *         typeName: AWS::Athena::WorkGroup
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCloudFormationType.
     * @return A collection of values returned by getCloudFormationType.
     */
    public suspend fun getCloudFormationType(argument: GetCloudFormationTypePlainArgs): GetCloudFormationTypeResult =
        getCloudFormationTypeResultToKotlin(getCloudFormationTypePlain(argument.toJava()).await())

    /**
     * @see [getCloudFormationType].
     * @param arn ARN of the CloudFormation Type. For example, `arn:aws:cloudformation:us-west-2::type/resource/AWS-EC2-VPC`.
     * @param type CloudFormation Registry Type. For example, `RESOURCE`.
     * @param typeName CloudFormation Type name. For example, `AWS::EC2::VPC`.
     * @param versionId Identifier of the CloudFormation Type version.
     * @return A collection of values returned by getCloudFormationType.
     */
    public suspend fun getCloudFormationType(
        arn: String? = null,
        type: String? = null,
        typeName: String? = null,
        versionId: String? = null,
    ): GetCloudFormationTypeResult {
        val argument = GetCloudFormationTypePlainArgs(
            arn = arn,
            type = type,
            typeName = typeName,
            versionId = versionId,
        )
        return getCloudFormationTypeResultToKotlin(getCloudFormationTypePlain(argument.toJava()).await())
    }

    /**
     * @see [getCloudFormationType].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudformation&#46;kotlin&#46;inputs&#46;GetCloudFormationTypePlainArgs].
     * @return A collection of values returned by getCloudFormationType.
     */
    public suspend fun getCloudFormationType(argument: suspend GetCloudFormationTypePlainArgsBuilder.() -> Unit): GetCloudFormationTypeResult {
        val builder = GetCloudFormationTypePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCloudFormationTypeResultToKotlin(getCloudFormationTypePlain(builtArgument.toJava()).await())
    }

    /**
     * The CloudFormation Export data source allows access to stack
     * exports specified in the [Output](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/outputs-section-structure.html) section of the Cloudformation Template using the optional Export Property.
     *  > Note: If you are trying to use a value from a Cloudformation Stack in the same deployment please use normal interpolation or Cloudformation Outputs.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const subnetId = aws.cloudformation.getExport({
     *     name: "mySubnetIdExportName",
     * });
     * const web = new aws.ec2.Instance("web", {
     *     ami: "ami-abb07bcb",
     *     instanceType: aws.ec2.InstanceType.T2_Micro,
     *     subnetId: subnetId.then(subnetId => subnetId.value),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * subnet_id = aws.cloudformation.get_export(name="mySubnetIdExportName")
     * web = aws.ec2.Instance("web",
     *     ami="ami-abb07bcb",
     *     instance_type=aws.ec2.InstanceType.T2_MICRO,
     *     subnet_id=subnet_id.value)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var subnetId = Aws.CloudFormation.GetExport.Invoke(new()
     *     {
     *         Name = "mySubnetIdExportName",
     *     });
     *     var web = new Aws.Ec2.Instance("web", new()
     *     {
     *         Ami = "ami-abb07bcb",
     *         InstanceType = Aws.Ec2.InstanceType.T2_Micro,
     *         SubnetId = subnetId.Apply(getExportResult => getExportResult.Value),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudformation"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		subnetId, err := cloudformation.GetExport(ctx, &cloudformation.GetExportArgs{
     * 			Name: "mySubnetIdExportName",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewInstance(ctx, "web", &ec2.InstanceArgs{
     * 			Ami:          pulumi.String("ami-abb07bcb"),
     * 			InstanceType: pulumi.String(ec2.InstanceType_T2_Micro),
     * 			SubnetId:     pulumi.String(subnetId.Value),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudformation.CloudformationFunctions;
     * import com.pulumi.aws.cloudformation.inputs.GetExportArgs;
     * import com.pulumi.aws.ec2.Instance;
     * import com.pulumi.aws.ec2.InstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var subnetId = CloudformationFunctions.getExport(GetExportArgs.builder()
     *             .name("mySubnetIdExportName")
     *             .build());
     *         var web = new Instance("web", InstanceArgs.builder()
     *             .ami("ami-abb07bcb")
     *             .instanceType("t2.micro")
     *             .subnetId(subnetId.applyValue(getExportResult -> getExportResult.value()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   web:
     *     type: aws:ec2:Instance
     *     properties:
     *       ami: ami-abb07bcb
     *       instanceType: t2.micro
     *       subnetId: ${subnetId.value}
     * variables:
     *   subnetId:
     *     fn::invoke:
     *       Function: aws:cloudformation:getExport
     *       Arguments:
     *         name: mySubnetIdExportName
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getExport.
     * @return A collection of values returned by getExport.
     */
    public suspend fun getExport(argument: GetExportPlainArgs): GetExportResult =
        getExportResultToKotlin(getExportPlain(argument.toJava()).await())

    /**
     * @see [getExport].
     * @param name Name of the export as it appears in the console or from [list-exports](http://docs.aws.amazon.com/cli/latest/reference/cloudformation/list-exports.html)
     * @return A collection of values returned by getExport.
     */
    public suspend fun getExport(name: String): GetExportResult {
        val argument = GetExportPlainArgs(
            name = name,
        )
        return getExportResultToKotlin(getExportPlain(argument.toJava()).await())
    }

    /**
     * @see [getExport].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudformation&#46;kotlin&#46;inputs&#46;GetExportPlainArgs].
     * @return A collection of values returned by getExport.
     */
    public suspend fun getExport(argument: suspend GetExportPlainArgsBuilder.() -> Unit): GetExportResult {
        val builder = GetExportPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExportResultToKotlin(getExportPlain(builtArgument.toJava()).await())
    }

    /**
     * The CloudFormation Stack data source allows access to stack
     * outputs and other useful data including the template body.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const network = aws.cloudformation.getStack({
     *     name: "my-network-stack",
     * });
     * const web = new aws.ec2.Instance("web", {
     *     ami: "ami-abb07bcb",
     *     instanceType: aws.ec2.InstanceType.T2_Micro,
     *     subnetId: network.then(network => network.outputs?.SubnetId),
     *     tags: {
     *         Name: "HelloWorld",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * network = aws.cloudformation.get_stack(name="my-network-stack")
     * web = aws.ec2.Instance("web",
     *     ami="ami-abb07bcb",
     *     instance_type=aws.ec2.InstanceType.T2_MICRO,
     *     subnet_id=network.outputs["SubnetId"],
     *     tags={
     *         "Name": "HelloWorld",
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var network = Aws.CloudFormation.GetStack.Invoke(new()
     *     {
     *         Name = "my-network-stack",
     *     });
     *     var web = new Aws.Ec2.Instance("web", new()
     *     {
     *         Ami = "ami-abb07bcb",
     *         InstanceType = Aws.Ec2.InstanceType.T2_Micro,
     *         SubnetId = network.Apply(getStackResult => getStackResult.Outputs?.SubnetId),
     *         Tags =
     *         {
     *             { "Name", "HelloWorld" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudformation"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		network, err := cloudformation.LookupStack(ctx, &cloudformation.LookupStackArgs{
     * 			Name: "my-network-stack",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewInstance(ctx, "web", &ec2.InstanceArgs{
     * 			Ami:          pulumi.String("ami-abb07bcb"),
     * 			InstanceType: pulumi.String(ec2.InstanceType_T2_Micro),
     * 			SubnetId:     pulumi.String(network.Outputs.SubnetId),
     * 			Tags: pulumi.StringMap{
     * 				"Name": pulumi.String("HelloWorld"),
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudformation.CloudformationFunctions;
     * import com.pulumi.aws.cloudformation.inputs.GetStackArgs;
     * import com.pulumi.aws.ec2.Instance;
     * import com.pulumi.aws.ec2.InstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var network = CloudformationFunctions.getStack(GetStackArgs.builder()
     *             .name("my-network-stack")
     *             .build());
     *         var web = new Instance("web", InstanceArgs.builder()
     *             .ami("ami-abb07bcb")
     *             .instanceType("t2.micro")
     *             .subnetId(network.applyValue(getStackResult -> getStackResult.outputs().SubnetId()))
     *             .tags(Map.of("Name", "HelloWorld"))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   web:
     *     type: aws:ec2:Instance
     *     properties:
     *       ami: ami-abb07bcb
     *       instanceType: t2.micro
     *       subnetId: ${network.outputs.SubnetId}
     *       tags:
     *         Name: HelloWorld
     * variables:
     *   network:
     *     fn::invoke:
     *       Function: aws:cloudformation:getStack
     *       Arguments:
     *         name: my-network-stack
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getStack.
     * @return A collection of values returned by getStack.
     */
    public suspend fun getStack(argument: GetStackPlainArgs): GetStackResult =
        getStackResultToKotlin(getStackPlain(argument.toJava()).await())

    /**
     * @see [getStack].
     * @param name Name of the stack
     * @param tags Map of tags associated with this stack.
     * @return A collection of values returned by getStack.
     */
    public suspend fun getStack(name: String, tags: Map<String, String>? = null): GetStackResult {
        val argument = GetStackPlainArgs(
            name = name,
            tags = tags,
        )
        return getStackResultToKotlin(getStackPlain(argument.toJava()).await())
    }

    /**
     * @see [getStack].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudformation&#46;kotlin&#46;inputs&#46;GetStackPlainArgs].
     * @return A collection of values returned by getStack.
     */
    public suspend fun getStack(argument: suspend GetStackPlainArgsBuilder.() -> Unit): GetStackResult {
        val builder = GetStackPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStackResultToKotlin(getStackPlain(builtArgument.toJava()).await())
    }
}
