@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Stack].
 */
@PulumiTagMarker
public class StackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StackArgs = StackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StackArgsBuilder.() -> Unit) {
        val builder = StackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Stack {
        val builtJavaResource = com.pulumi.aws.cloudformation.Stack(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Stack(builtJavaResource)
    }
}

/**
 * Provides a CloudFormation Stack resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const network = new aws.cloudformation.Stack("network", {
 *     name: "networking-stack",
 *     parameters: {
 *         VPCCidr: "10.0.0.0/16",
 *     },
 *     templateBody: JSON.stringify({
 *         Parameters: {
 *             VPCCidr: {
 *                 Type: "String",
 *                 Default: "10.0.0.0/16",
 *                 Description: "Enter the CIDR block for the VPC. Default is 10.0.0.0/16.",
 *             },
 *         },
 *         Resources: {
 *             myVpc: {
 *                 Type: "AWS::EC2::VPC",
 *                 Properties: {
 *                     CidrBlock: {
 *                         Ref: "VPCCidr",
 *                     },
 *                     Tags: [{
 *                         Key: "Name",
 *                         Value: "Primary_CF_VPC",
 *                     }],
 *                 },
 *             },
 *         },
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * network = aws.cloudformation.Stack("network",
 *     name="networking-stack",
 *     parameters={
 *         "VPCCidr": "10.0.0.0/16",
 *     },
 *     template_body=json.dumps({
 *         "Parameters": {
 *             "VPCCidr": {
 *                 "Type": "String",
 *                 "Default": "10.0.0.0/16",
 *                 "Description": "Enter the CIDR block for the VPC. Default is 10.0.0.0/16.",
 *             },
 *         },
 *         "Resources": {
 *             "myVpc": {
 *                 "Type": "AWS::EC2::VPC",
 *                 "Properties": {
 *                     "CidrBlock": {
 *                         "Ref": "VPCCidr",
 *                     },
 *                     "Tags": [{
 *                         "Key": "Name",
 *                         "Value": "Primary_CF_VPC",
 *                     }],
 *                 },
 *             },
 *         },
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var network = new Aws.CloudFormation.Stack("network", new()
 *     {
 *         Name = "networking-stack",
 *         Parameters =
 *         {
 *             { "VPCCidr", "10.0.0.0/16" },
 *         },
 *         TemplateBody = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Parameters"] = new Dictionary<string, object?>
 *             {
 *                 ["VPCCidr"] = new Dictionary<string, object?>
 *                 {
 *                     ["Type"] = "String",
 *                     ["Default"] = "10.0.0.0/16",
 *                     ["Description"] = "Enter the CIDR block for the VPC. Default is 10.0.0.0/16.",
 *                 },
 *             },
 *             ["Resources"] = new Dictionary<string, object?>
 *             {
 *                 ["myVpc"] = new Dictionary<string, object?>
 *                 {
 *                     ["Type"] = "AWS::EC2::VPC",
 *                     ["Properties"] = new Dictionary<string, object?>
 *                     {
 *                         ["CidrBlock"] = new Dictionary<string, object?>
 *                         {
 *                             ["Ref"] = "VPCCidr",
 *                         },
 *                         ["Tags"] = new[]
 *                         {
 *                             new Dictionary<string, object?>
 *                             {
 *                                 ["Key"] = "Name",
 *                                 ["Value"] = "Primary_CF_VPC",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Parameters": map[string]interface{}{
 * 				"VPCCidr": map[string]interface{}{
 * 					"Type":        "String",
 * 					"Default":     "10.0.0.0/16",
 * 					"Description": "Enter the CIDR block for the VPC. Default is 10.0.0.0/16.",
 * 				},
 * 			},
 * 			"Resources": map[string]interface{}{
 * 				"myVpc": map[string]interface{}{
 * 					"Type": "AWS::EC2::VPC",
 * 					"Properties": map[string]interface{}{
 * 						"CidrBlock": map[string]interface{}{
 * 							"Ref": "VPCCidr",
 * 						},
 * 						"Tags": []map[string]interface{}{
 * 							map[string]interface{}{
 * 								"Key":   "Name",
 * 								"Value": "Primary_CF_VPC",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = cloudformation.NewStack(ctx, "network", &cloudformation.StackArgs{
 * 			Name: pulumi.String("networking-stack"),
 * 			Parameters: pulumi.StringMap{
 * 				"VPCCidr": pulumi.String("10.0.0.0/16"),
 * 			},
 * 			TemplateBody: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudformation.Stack;
 * import com.pulumi.aws.cloudformation.StackArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var network = new Stack("network", StackArgs.builder()
 *             .name("networking-stack")
 *             .parameters(Map.of("VPCCidr", "10.0.0.0/16"))
 *             .templateBody(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Parameters", jsonObject(
 *                         jsonProperty("VPCCidr", jsonObject(
 *                             jsonProperty("Type", "String"),
 *                             jsonProperty("Default", "10.0.0.0/16"),
 *                             jsonProperty("Description", "Enter the CIDR block for the VPC. Default is 10.0.0.0/16.")
 *                         ))
 *                     )),
 *                     jsonProperty("Resources", jsonObject(
 *                         jsonProperty("myVpc", jsonObject(
 *                             jsonProperty("Type", "AWS::EC2::VPC"),
 *                             jsonProperty("Properties", jsonObject(
 *                                 jsonProperty("CidrBlock", jsonObject(
 *                                     jsonProperty("Ref", "VPCCidr")
 *                                 )),
 *                                 jsonProperty("Tags", jsonArray(jsonObject(
 *                                     jsonProperty("Key", "Name"),
 *                                     jsonProperty("Value", "Primary_CF_VPC")
 *                                 )))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   network:
 *     type: aws:cloudformation:Stack
 *     properties:
 *       name: networking-stack
 *       parameters:
 *         VPCCidr: 10.0.0.0/16
 *       templateBody:
 *         fn::toJSON:
 *           Parameters:
 *             VPCCidr:
 *               Type: String
 *               Default: 10.0.0.0/16
 *               Description: Enter the CIDR block for the VPC. Default is 10.0.0.0/16.
 *           Resources:
 *             myVpc:
 *               Type: AWS::EC2::VPC
 *               Properties:
 *                 CidrBlock:
 *                   Ref: VPCCidr
 *                 Tags:
 *                   - Key: Name
 *                     Value: Primary_CF_VPC
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cloudformation Stacks using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cloudformation/stack:Stack stack networking-stack
 * ```
 */
public class Stack internal constructor(
    override val javaResource: com.pulumi.aws.cloudformation.Stack,
) : KotlinCustomResource(javaResource, StackMapper) {
    /**
     * A list of capabilities.
     * Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, or `CAPABILITY_AUTO_EXPAND`
     */
    public val capabilities: Output<List<String>>?
        get() = javaResource.capabilities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Set to true to disable rollback of the stack if stack creation failed.
     * Conflicts with `on_failure`.
     */
    public val disableRollback: Output<Boolean>?
        get() = javaResource.disableRollback().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of an IAM role that AWS CloudFormation assumes to create the stack. If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
     */
    public val iamRoleArn: Output<String>?
        get() = javaResource.iamRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Stack name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A list of SNS topic ARNs to publish stack related events.
     */
    public val notificationArns: Output<List<String>>?
        get() = javaResource.notificationArns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Action to be taken if stack creation fails. This must be
     * one of: `DO_NOTHING`, `ROLLBACK`, or `DELETE`. Conflicts with `disable_rollback`.
     */
    public val onFailure: Output<String>?
        get() = javaResource.onFailure().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A map of outputs from the stack.
     */
    public val outputs: Output<Map<String, String>>
        get() = javaResource.outputs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A map of Parameter structures that specify input parameters for the stack.
     */
    public val parameters: Output<Map<String, String>>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Structure containing the stack policy body.
     * Conflicts w/ `policy_url`.
     */
    public val policyBody: Output<String>
        get() = javaResource.policyBody().applyValue({ args0 -> args0 })

    /**
     * Location of a file containing the stack policy.
     * Conflicts w/ `policy_body`.
     */
    public val policyUrl: Output<String>?
        get() = javaResource.policyUrl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Map of resource tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Structure containing the template body (max size: 51,200 bytes).
     */
    public val templateBody: Output<String>
        get() = javaResource.templateBody().applyValue({ args0 -> args0 })

    /**
     * Location of a file containing the template body (max size: 460,800 bytes).
     */
    public val templateUrl: Output<String>?
        get() = javaResource.templateUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The amount of time that can pass before the stack status becomes `CREATE_FAILED`.
     */
    public val timeoutInMinutes: Output<Int>?
        get() = javaResource.timeoutInMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object StackMapper : ResourceMapper<Stack> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudformation.Stack::class == javaResource::class

    override fun map(javaResource: Resource): Stack = Stack(
        javaResource as
            com.pulumi.aws.cloudformation.Stack,
    )
}

/**
 * @see [Stack].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Stack].
 */
public suspend fun stack(name: String, block: suspend StackResourceBuilder.() -> Unit): Stack {
    val builder = StackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Stack].
 * @param name The _unique_ name of the resulting resource.
 */
public fun stack(name: String): Stack {
    val builder = StackResourceBuilder()
    builder.name(name)
    return builder.build()
}
