@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.inputs

import com.pulumi.aws.cloudformation.inputs.GetCloudFormationTypePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCloudFormationType.
 * @property arn ARN of the CloudFormation Type. For example, `arn:aws:cloudformation:us-west-2::type/resource/AWS-EC2-VPC`.
 * @property type CloudFormation Registry Type. For example, `RESOURCE`.
 * @property typeName CloudFormation Type name. For example, `AWS::EC2::VPC`.
 * @property versionId Identifier of the CloudFormation Type version.
 */
public data class GetCloudFormationTypePlainArgs(
    public val arn: String? = null,
    public val type: String? = null,
    public val typeName: String? = null,
    public val versionId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudformation.inputs.GetCloudFormationTypePlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudformation.inputs.GetCloudFormationTypePlainArgs =
        com.pulumi.aws.cloudformation.inputs.GetCloudFormationTypePlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 }))
            .typeName(typeName?.let({ args0 -> args0 }))
            .versionId(versionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCloudFormationTypePlainArgs].
 */
@PulumiTagMarker
public class GetCloudFormationTypePlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var type: String? = null

    private var typeName: String? = null

    private var versionId: String? = null

    /**
     * @param value ARN of the CloudFormation Type. For example, `arn:aws:cloudformation:us-west-2::type/resource/AWS-EC2-VPC`.
     */
    @JvmName("gjcdhiwmeucghhvq")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value CloudFormation Registry Type. For example, `RESOURCE`.
     */
    @JvmName("ghrwpsyffooqptos")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value CloudFormation Type name. For example, `AWS::EC2::VPC`.
     */
    @JvmName("wjfdakqpfnwoqwgt")
    public suspend fun typeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.typeName = mapped
    }

    /**
     * @param value Identifier of the CloudFormation Type version.
     */
    @JvmName("yytbgsrysoifleab")
    public suspend fun versionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.versionId = mapped
    }

    internal fun build(): GetCloudFormationTypePlainArgs = GetCloudFormationTypePlainArgs(
        arn = arn,
        type = type,
        typeName = typeName,
        versionId = versionId,
    )
}
