@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.inputs

import com.pulumi.aws.cloudformation.inputs.GetExportPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getExport.
 * @property name Name of the export as it appears in the console or from [list-exports](http://docs.aws.amazon.com/cli/latest/reference/cloudformation/list-exports.html)
 */
public data class GetExportPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.cloudformation.inputs.GetExportPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudformation.inputs.GetExportPlainArgs =
        com.pulumi.aws.cloudformation.inputs.GetExportPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExportPlainArgs].
 */
@PulumiTagMarker
public class GetExportPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the export as it appears in the console or from [list-exports](http://docs.aws.amazon.com/cli/latest/reference/cloudformation/list-exports.html)
     */
    @JvmName("eqvowxctsvxonkia")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetExportPlainArgs = GetExportPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
