@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.inputs

import com.pulumi.aws.cloudformation.inputs.StackSetAutoDeploymentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether or not auto-deployment is enabled.
 * @property retainStacksOnAccountRemoval Whether or not to retain stacks when the account is removed.
 */
public data class StackSetAutoDeploymentArgs(
    public val enabled: Output<Boolean>? = null,
    public val retainStacksOnAccountRemoval: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudformation.inputs.StackSetAutoDeploymentArgs> {
    override fun toJava(): com.pulumi.aws.cloudformation.inputs.StackSetAutoDeploymentArgs =
        com.pulumi.aws.cloudformation.inputs.StackSetAutoDeploymentArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .retainStacksOnAccountRemoval(retainStacksOnAccountRemoval?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackSetAutoDeploymentArgs].
 */
@PulumiTagMarker
public class StackSetAutoDeploymentArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var retainStacksOnAccountRemoval: Output<Boolean>? = null

    /**
     * @param value Whether or not auto-deployment is enabled.
     */
    @JvmName("qxykipkrtlrjcnpj")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether or not to retain stacks when the account is removed.
     */
    @JvmName("rxtculrabwoqdyne")
    public suspend fun retainStacksOnAccountRemoval(`value`: Output<Boolean>) {
        this.retainStacksOnAccountRemoval = value
    }

    /**
     * @param value Whether or not auto-deployment is enabled.
     */
    @JvmName("bfwdwnvmoxuedsdx")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Whether or not to retain stacks when the account is removed.
     */
    @JvmName("ntssyijgjxlqjtfv")
    public suspend fun retainStacksOnAccountRemoval(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainStacksOnAccountRemoval = mapped
    }

    internal fun build(): StackSetAutoDeploymentArgs = StackSetAutoDeploymentArgs(
        enabled = enabled,
        retainStacksOnAccountRemoval = retainStacksOnAccountRemoval,
    )
}
