@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.inputs

import com.pulumi.aws.cloudformation.inputs.StackSetInstanceDeploymentTargetsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property accountFilterType Limit deployment targets to individual accounts or include additional accounts with provided OUs. Valid values: `INTERSECTION`, `DIFFERENCE`, `UNION`, `NONE`.
 * @property accounts List of accounts to deploy stack set updates.
 * @property accountsUrl S3 URL of the file containing the list of accounts.
 * @property organizationalUnitIds Organization root ID or organizational unit (OU) IDs to which StackSets deploys.
 */
public data class StackSetInstanceDeploymentTargetsArgs(
    public val accountFilterType: Output<String>? = null,
    public val accounts: Output<List<String>>? = null,
    public val accountsUrl: Output<String>? = null,
    public val organizationalUnitIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudformation.inputs.StackSetInstanceDeploymentTargetsArgs> {
    override fun toJava(): com.pulumi.aws.cloudformation.inputs.StackSetInstanceDeploymentTargetsArgs = com.pulumi.aws.cloudformation.inputs.StackSetInstanceDeploymentTargetsArgs.builder()
        .accountFilterType(accountFilterType?.applyValue({ args0 -> args0 }))
        .accounts(accounts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .accountsUrl(accountsUrl?.applyValue({ args0 -> args0 }))
        .organizationalUnitIds(
            organizationalUnitIds?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }),
        ).build()
}

/**
 * Builder for [StackSetInstanceDeploymentTargetsArgs].
 */
@PulumiTagMarker
public class StackSetInstanceDeploymentTargetsArgsBuilder internal constructor() {
    private var accountFilterType: Output<String>? = null

    private var accounts: Output<List<String>>? = null

    private var accountsUrl: Output<String>? = null

    private var organizationalUnitIds: Output<List<String>>? = null

    /**
     * @param value Limit deployment targets to individual accounts or include additional accounts with provided OUs. Valid values: `INTERSECTION`, `DIFFERENCE`, `UNION`, `NONE`.
     */
    @JvmName("koxnraujhecfsnrm")
    public suspend fun accountFilterType(`value`: Output<String>) {
        this.accountFilterType = value
    }

    /**
     * @param value List of accounts to deploy stack set updates.
     */
    @JvmName("uxhjjrlxnhqmohuk")
    public suspend fun accounts(`value`: Output<List<String>>) {
        this.accounts = value
    }

    @JvmName("llcumfhjorsevyem")
    public suspend fun accounts(vararg values: Output<String>) {
        this.accounts = Output.all(values.asList())
    }

    /**
     * @param values List of accounts to deploy stack set updates.
     */
    @JvmName("ysayccsolaqxcqxx")
    public suspend fun accounts(values: List<Output<String>>) {
        this.accounts = Output.all(values)
    }

    /**
     * @param value S3 URL of the file containing the list of accounts.
     */
    @JvmName("iqdkxsaujpmbkxbw")
    public suspend fun accountsUrl(`value`: Output<String>) {
        this.accountsUrl = value
    }

    /**
     * @param value Organization root ID or organizational unit (OU) IDs to which StackSets deploys.
     */
    @JvmName("qqfgyaqsfwvugxjd")
    public suspend fun organizationalUnitIds(`value`: Output<List<String>>) {
        this.organizationalUnitIds = value
    }

    @JvmName("fecmqmftbaitlunq")
    public suspend fun organizationalUnitIds(vararg values: Output<String>) {
        this.organizationalUnitIds = Output.all(values.asList())
    }

    /**
     * @param values Organization root ID or organizational unit (OU) IDs to which StackSets deploys.
     */
    @JvmName("jajnppnxucioktem")
    public suspend fun organizationalUnitIds(values: List<Output<String>>) {
        this.organizationalUnitIds = Output.all(values)
    }

    /**
     * @param value Limit deployment targets to individual accounts or include additional accounts with provided OUs. Valid values: `INTERSECTION`, `DIFFERENCE`, `UNION`, `NONE`.
     */
    @JvmName("hrxpxhvbrcubguce")
    public suspend fun accountFilterType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountFilterType = mapped
    }

    /**
     * @param value List of accounts to deploy stack set updates.
     */
    @JvmName("tnwmtljvkxpseeho")
    public suspend fun accounts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accounts = mapped
    }

    /**
     * @param values List of accounts to deploy stack set updates.
     */
    @JvmName("vwialrryxqlcnxxc")
    public suspend fun accounts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accounts = mapped
    }

    /**
     * @param value S3 URL of the file containing the list of accounts.
     */
    @JvmName("mqsodiibwpsrcusi")
    public suspend fun accountsUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountsUrl = mapped
    }

    /**
     * @param value Organization root ID or organizational unit (OU) IDs to which StackSets deploys.
     */
    @JvmName("cjpcmfyqnestqudr")
    public suspend fun organizationalUnitIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalUnitIds = mapped
    }

    /**
     * @param values Organization root ID or organizational unit (OU) IDs to which StackSets deploys.
     */
    @JvmName("vkdidahnvxgvjxcf")
    public suspend fun organizationalUnitIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationalUnitIds = mapped
    }

    internal fun build(): StackSetInstanceDeploymentTargetsArgs =
        StackSetInstanceDeploymentTargetsArgs(
            accountFilterType = accountFilterType,
            accounts = accounts,
            accountsUrl = accountsUrl,
            organizationalUnitIds = organizationalUnitIds,
        )
}
