@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.inputs

import com.pulumi.aws.cloudformation.inputs.StackSetInstanceOperationPreferencesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property concurrencyMode Specifies how the concurrency level behaves during the operation execution. Valid values are `STRICT_FAILURE_TOLERANCE` and `SOFT_FAILURE_TOLERANCE`.
 * @property failureToleranceCount Number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
 * @property failureTolerancePercentage Percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
 * @property maxConcurrentCount Maximum number of accounts in which to perform this operation at one time.
 * @property maxConcurrentPercentage Maximum percentage of accounts in which to perform this operation at one time.
 * @property regionConcurrencyType Concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time. Valid values are `SEQUENTIAL` and `PARALLEL`.
 * @property regionOrders Order of the Regions in where you want to perform the stack operation.
 */
public data class StackSetInstanceOperationPreferencesArgs(
    public val concurrencyMode: Output<String>? = null,
    public val failureToleranceCount: Output<Int>? = null,
    public val failureTolerancePercentage: Output<Int>? = null,
    public val maxConcurrentCount: Output<Int>? = null,
    public val maxConcurrentPercentage: Output<Int>? = null,
    public val regionConcurrencyType: Output<String>? = null,
    public val regionOrders: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudformation.inputs.StackSetInstanceOperationPreferencesArgs> {
    override fun toJava(): com.pulumi.aws.cloudformation.inputs.StackSetInstanceOperationPreferencesArgs =
        com.pulumi.aws.cloudformation.inputs.StackSetInstanceOperationPreferencesArgs.builder()
            .concurrencyMode(concurrencyMode?.applyValue({ args0 -> args0 }))
            .failureToleranceCount(failureToleranceCount?.applyValue({ args0 -> args0 }))
            .failureTolerancePercentage(failureTolerancePercentage?.applyValue({ args0 -> args0 }))
            .maxConcurrentCount(maxConcurrentCount?.applyValue({ args0 -> args0 }))
            .maxConcurrentPercentage(maxConcurrentPercentage?.applyValue({ args0 -> args0 }))
            .regionConcurrencyType(regionConcurrencyType?.applyValue({ args0 -> args0 }))
            .regionOrders(regionOrders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [StackSetInstanceOperationPreferencesArgs].
 */
@PulumiTagMarker
public class StackSetInstanceOperationPreferencesArgsBuilder internal constructor() {
    private var concurrencyMode: Output<String>? = null

    private var failureToleranceCount: Output<Int>? = null

    private var failureTolerancePercentage: Output<Int>? = null

    private var maxConcurrentCount: Output<Int>? = null

    private var maxConcurrentPercentage: Output<Int>? = null

    private var regionConcurrencyType: Output<String>? = null

    private var regionOrders: Output<List<String>>? = null

    /**
     * @param value Specifies how the concurrency level behaves during the operation execution. Valid values are `STRICT_FAILURE_TOLERANCE` and `SOFT_FAILURE_TOLERANCE`.
     */
    @JvmName("ihpgtwuiprtpxpil")
    public suspend fun concurrencyMode(`value`: Output<String>) {
        this.concurrencyMode = value
    }

    /**
     * @param value Number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
     */
    @JvmName("igijebppilupteja")
    public suspend fun failureToleranceCount(`value`: Output<Int>) {
        this.failureToleranceCount = value
    }

    /**
     * @param value Percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
     */
    @JvmName("auwvlvjbaiyorspk")
    public suspend fun failureTolerancePercentage(`value`: Output<Int>) {
        this.failureTolerancePercentage = value
    }

    /**
     * @param value Maximum number of accounts in which to perform this operation at one time.
     */
    @JvmName("dwkvmdccovfeldnv")
    public suspend fun maxConcurrentCount(`value`: Output<Int>) {
        this.maxConcurrentCount = value
    }

    /**
     * @param value Maximum percentage of accounts in which to perform this operation at one time.
     */
    @JvmName("tajrqpkmdqvadvlk")
    public suspend fun maxConcurrentPercentage(`value`: Output<Int>) {
        this.maxConcurrentPercentage = value
    }

    /**
     * @param value Concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time. Valid values are `SEQUENTIAL` and `PARALLEL`.
     */
    @JvmName("lvvnavfynjeuonfs")
    public suspend fun regionConcurrencyType(`value`: Output<String>) {
        this.regionConcurrencyType = value
    }

    /**
     * @param value Order of the Regions in where you want to perform the stack operation.
     */
    @JvmName("kwhymgmobielrfbl")
    public suspend fun regionOrders(`value`: Output<List<String>>) {
        this.regionOrders = value
    }

    @JvmName("jhggwhfunatfwmvx")
    public suspend fun regionOrders(vararg values: Output<String>) {
        this.regionOrders = Output.all(values.asList())
    }

    /**
     * @param values Order of the Regions in where you want to perform the stack operation.
     */
    @JvmName("swpnrfjfbjjmjklk")
    public suspend fun regionOrders(values: List<Output<String>>) {
        this.regionOrders = Output.all(values)
    }

    /**
     * @param value Specifies how the concurrency level behaves during the operation execution. Valid values are `STRICT_FAILURE_TOLERANCE` and `SOFT_FAILURE_TOLERANCE`.
     */
    @JvmName("xwddppxnefsepxve")
    public suspend fun concurrencyMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.concurrencyMode = mapped
    }

    /**
     * @param value Number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
     */
    @JvmName("fncoapjxggmxxuhu")
    public suspend fun failureToleranceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureToleranceCount = mapped
    }

    /**
     * @param value Percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
     */
    @JvmName("eomwlkwmharashtc")
    public suspend fun failureTolerancePercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureTolerancePercentage = mapped
    }

    /**
     * @param value Maximum number of accounts in which to perform this operation at one time.
     */
    @JvmName("acdcwkheyctdewur")
    public suspend fun maxConcurrentCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentCount = mapped
    }

    /**
     * @param value Maximum percentage of accounts in which to perform this operation at one time.
     */
    @JvmName("fxxineksjdkfssnm")
    public suspend fun maxConcurrentPercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentPercentage = mapped
    }

    /**
     * @param value Concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time. Valid values are `SEQUENTIAL` and `PARALLEL`.
     */
    @JvmName("misdoibfdrwcnrfi")
    public suspend fun regionConcurrencyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionConcurrencyType = mapped
    }

    /**
     * @param value Order of the Regions in where you want to perform the stack operation.
     */
    @JvmName("ctfyitgyospdojsx")
    public suspend fun regionOrders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionOrders = mapped
    }

    /**
     * @param values Order of the Regions in where you want to perform the stack operation.
     */
    @JvmName("ahiyehhgmfnhbjfg")
    public suspend fun regionOrders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionOrders = mapped
    }

    internal fun build(): StackSetInstanceOperationPreferencesArgs =
        StackSetInstanceOperationPreferencesArgs(
            concurrencyMode = concurrencyMode,
            failureToleranceCount = failureToleranceCount,
            failureTolerancePercentage = failureTolerancePercentage,
            maxConcurrentCount = maxConcurrentCount,
            maxConcurrentPercentage = maxConcurrentPercentage,
            regionConcurrencyType = regionConcurrencyType,
            regionOrders = regionOrders,
        )
}
