@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.inputs

import com.pulumi.aws.cloudformation.inputs.StackSetManagedExecutionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property active When set to true, StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order. Default is false.
 */
public data class StackSetManagedExecutionArgs(
    public val active: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudformation.inputs.StackSetManagedExecutionArgs> {
    override fun toJava(): com.pulumi.aws.cloudformation.inputs.StackSetManagedExecutionArgs =
        com.pulumi.aws.cloudformation.inputs.StackSetManagedExecutionArgs.builder()
            .active(active?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackSetManagedExecutionArgs].
 */
@PulumiTagMarker
public class StackSetManagedExecutionArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    /**
     * @param value When set to true, StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order. Default is false.
     */
    @JvmName("bcemnnbiqeyqysbk")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value When set to true, StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order. Default is false.
     */
    @JvmName("whjclcfxyuuawklt")
    public suspend fun active(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.active = mapped
    }

    internal fun build(): StackSetManagedExecutionArgs = StackSetManagedExecutionArgs(
        active = active,
    )
}
