@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property logGroupName Name of the CloudWatch Log Group where CloudFormation sends error logging information when invoking the type's handlers.
 * @property logRoleArn Amazon Resource Name (ARN) of the IAM Role CloudFormation assumes when sending error logging information to CloudWatch Logs.
 */
public data class CloudFormationTypeLoggingConfig(
    public val logGroupName: String,
    public val logRoleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudformation.outputs.CloudFormationTypeLoggingConfig): CloudFormationTypeLoggingConfig = CloudFormationTypeLoggingConfig(
            logGroupName = javaType.logGroupName(),
            logRoleArn = javaType.logRoleArn(),
        )
    }
}
