@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property logGroupName Name of the CloudWatch Log Group where CloudFormation sends error logging information when invoking the type's handlers.
 * @property logRoleArn ARN of the IAM Role CloudFormation assumes when sending error logging information to CloudWatch Logs.
 */
public data class GetCloudFormationTypeLoggingConfig(
    public val logGroupName: String,
    public val logRoleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudformation.outputs.GetCloudFormationTypeLoggingConfig): GetCloudFormationTypeLoggingConfig = GetCloudFormationTypeLoggingConfig(
            logGroupName = javaType.logGroupName(),
            logRoleArn = javaType.logRoleArn(),
        )
    }
}
