@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getStack.
 * @property capabilities List of capabilities
 * @property description Description of the stack
 * @property disableRollback Whether the rollback of the stack is disabled when stack creation fails
 * @property iamRoleArn ARN of the IAM role used to create the stack.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property notificationArns List of SNS topic ARNs to publish stack related events
 * @property outputs Map of outputs from the stack.
 * @property parameters Map of parameters that specify input parameters for the stack.
 * @property tags Map of tags associated with this stack.
 * @property templateBody Structure containing the template body.
 * @property timeoutInMinutes Amount of time that can pass before the stack status becomes `CREATE_FAILED`
 */
public data class GetStackResult(
    public val capabilities: List<String>,
    public val description: String,
    public val disableRollback: Boolean,
    public val iamRoleArn: String,
    public val id: String,
    public val name: String,
    public val notificationArns: List<String>,
    public val outputs: Map<String, String>,
    public val parameters: Map<String, String>,
    public val tags: Map<String, String>,
    public val templateBody: String,
    public val timeoutInMinutes: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudformation.outputs.GetStackResult): GetStackResult = GetStackResult(
            capabilities = javaType.capabilities().map({ args0 -> args0 }),
            description = javaType.description(),
            disableRollback = javaType.disableRollback(),
            iamRoleArn = javaType.iamRoleArn(),
            id = javaType.id(),
            name = javaType.name(),
            notificationArns = javaType.notificationArns().map({ args0 -> args0 }),
            outputs = javaType.outputs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            templateBody = javaType.templateBody(),
            timeoutInMinutes = javaType.timeoutInMinutes(),
        )
    }
}
