@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accountFilterType Limit deployment targets to individual accounts or include additional accounts with provided OUs. Valid values: `INTERSECTION`, `DIFFERENCE`, `UNION`, `NONE`.
 * @property accounts List of accounts to deploy stack set updates.
 * @property accountsUrl S3 URL of the file containing the list of accounts.
 * @property organizationalUnitIds Organization root ID or organizational unit (OU) IDs to which StackSets deploys.
 */
public data class StackSetInstanceDeploymentTargets(
    public val accountFilterType: String? = null,
    public val accounts: List<String>? = null,
    public val accountsUrl: String? = null,
    public val organizationalUnitIds: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudformation.outputs.StackSetInstanceDeploymentTargets): StackSetInstanceDeploymentTargets = StackSetInstanceDeploymentTargets(
            accountFilterType = javaType.accountFilterType().map({ args0 -> args0 }).orElse(null),
            accounts = javaType.accounts().map({ args0 -> args0 }),
            accountsUrl = javaType.accountsUrl().map({ args0 -> args0 }).orElse(null),
            organizationalUnitIds = javaType.organizationalUnitIds().map({ args0 -> args0 }),
        )
    }
}
