@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property concurrencyMode Specifies how the concurrency level behaves during the operation execution. Valid values are `STRICT_FAILURE_TOLERANCE` and `SOFT_FAILURE_TOLERANCE`.
 * @property failureToleranceCount Number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
 * @property failureTolerancePercentage Percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
 * @property maxConcurrentCount Maximum number of accounts in which to perform this operation at one time.
 * @property maxConcurrentPercentage Maximum percentage of accounts in which to perform this operation at one time.
 * @property regionConcurrencyType Concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time. Valid values are `SEQUENTIAL` and `PARALLEL`.
 * @property regionOrders Order of the Regions in where you want to perform the stack operation.
 */
public data class StackSetInstanceOperationPreferences(
    public val concurrencyMode: String? = null,
    public val failureToleranceCount: Int? = null,
    public val failureTolerancePercentage: Int? = null,
    public val maxConcurrentCount: Int? = null,
    public val maxConcurrentPercentage: Int? = null,
    public val regionConcurrencyType: String? = null,
    public val regionOrders: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudformation.outputs.StackSetInstanceOperationPreferences): StackSetInstanceOperationPreferences = StackSetInstanceOperationPreferences(
            concurrencyMode = javaType.concurrencyMode().map({ args0 -> args0 }).orElse(null),
            failureToleranceCount = javaType.failureToleranceCount().map({ args0 -> args0 }).orElse(null),
            failureTolerancePercentage = javaType.failureTolerancePercentage().map({ args0 ->
                args0
            }).orElse(null),
            maxConcurrentCount = javaType.maxConcurrentCount().map({ args0 -> args0 }).orElse(null),
            maxConcurrentPercentage = javaType.maxConcurrentPercentage().map({ args0 -> args0 }).orElse(null),
            regionConcurrencyType = javaType.regionConcurrencyType().map({ args0 -> args0 }).orElse(null),
            regionOrders = javaType.regionOrders().map({ args0 -> args0 }),
        )
    }
}
